package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefEspeceTopiaDao.java 4329 2014-09-12 15:14:03Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefEspeceTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaException;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class RefEspeceTopiaDao extends AbstractRefEspeceTopiaDao<RefEspece> {

    /**
     * Search all RefCommuneValues matching user navigation context and custom additional {@code filter}.
     *
     * @param filter custom filter
     * @return matching domains
     * @throws org.nuiton.topia.persistence.TopiaException
     *
     */
    public List<RefEspece> findActiveEspeces(String filter, int maxResults) throws TopiaException {
        if (Strings.isNullOrEmpty(filter)) {
            return Lists.newArrayList();
        }
        String query = "FROM " + getEntityClass().getName() + " re";
        query += " WHERE re." + RefEspece.PROPERTY_ACTIVE + " = true";
        Map<String, Object> args = Maps.newLinkedHashMap();

        // first name
        String escapedFilter = StringUtils.stripAccents(filter.trim());
        query += DaoUtils.andAttributeLike("re", RefEspece.PROPERTY_LIBELLE_ESPECE_BOTANIQUE, args, escapedFilter);

        query += " ORDER BY re." + RefEspece.PROPERTY_LIBELLE_ESPECE_BOTANIQUE;

        List<RefEspece> result = find(query, args, 0, maxResults);

        return result;
    }

} //RefEspeceTopiaDao<E extends RefEspece>
