package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefClonePlantGrapeTopiaDao.java 4671 2014-12-17 15:44:10Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefClonePlantGrapeTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

public class RefClonePlantGrapeTopiaDao extends AbstractRefClonePlantGrapeTopiaDao<RefClonePlantGrape> {

    public List<RefClonePlantGrape> findGraftClones(String filter, int codeVar, int maxResults) {
        List<RefClonePlantGrape> result = null;
        if (filter != null) {
            String query = "FROM " + RefClonePlantGrape.class.getName() + " CPG";
            query += " WHERE CPG." + RefClonePlantGrape.PROPERTY_ACTIVE + " = true";

            Map<String, Object> args = Maps.newLinkedHashMap();

            query += " AND CAST(CPG." + RefClonePlantGrape.PROPERTY_CODE_VAR + " as text) LIKE :codeVar";
            args.put("codeVar", String.valueOf(codeVar));

            if (StringUtils.isNotBlank(filter)){
                query += " AND CAST(CPG." + RefClonePlantGrape.PROPERTY_CODE_CLONE + " as text)  LIKE CONCAT('%',:filter,'%') ";
                args.put("filter", String.valueOf(filter));
            }

            query += " ORDER BY CPG." + RefClonePlantGrape.PROPERTY_CODE_VAR + ", CPG." + RefClonePlantGrape.PROPERTY_CODE_CLONE;

            result = find(query, args, 0, maxResults - 1);
        }
        return result;
    }

} //RefClonePlantGrapeTopiaDao<E extends RefClonePlantGrape>
