package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefActaTraitementsProduitsCategTopiaDao.java 3960 2014-04-01 16:59:22Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefActaTraitementsProduitsCategTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.utils.DaoUtils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RefActaTraitementsProduitsCategTopiaDao extends AbstractRefActaTraitementsProduitsCategTopiaDao<RefActaTraitementsProduitsCateg> {

    public LinkedHashMap<AgrosystInterventionType, List<String>> findAllActiveActaTreatmentProductType() {
        Map<String, Object> args = DaoUtils.asArgsMap();

        String query = "SELECT DISTINCT" +
                " acta_tpc." + RefActaTraitementsProduitsCateg.PROPERTY_ACTION + ", acta_tpc." + RefActaTraitementsProduitsCateg.PROPERTY_TYPE_PRODUIT +
                " FROM " + getEntityClass().getName() + " acta_tpc " +
                " WHERE 1 = 1 ";
        query += DaoUtils.andAttributeEquals("acta_tpc", RefActaTraitementsProduitsCateg.PROPERTY_ACTIVE, args, true);
        query += " ORDER BY acta_tpc." + RefActaTraitementsProduitsCateg.PROPERTY_TYPE_PRODUIT + " ASC ";


        List<Object[]> queryResult = findAll(query, args);

        LinkedHashMap<AgrosystInterventionType, List<String>> allActiveProductType = Maps.newLinkedHashMap();
        if (queryResult != null) {
            for (Object[] entry : queryResult) {
                AgrosystInterventionType agrosystInterventionType = (AgrosystInterventionType) entry[0];
                List<String> treatmentsList = allActiveProductType.get(agrosystInterventionType);
                if (treatmentsList == null) {
                    treatmentsList = Lists.newArrayList();
                }
                treatmentsList.add((String) entry[1]);
                allActiveProductType.put(agrosystInterventionType, treatmentsList);
            }
        }

        return allActiveProductType;
    }

} //RefActaTraitementsProduitsCategTopiaDao
