package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefActaTraitementsProduitTopiaDao.java 4056 2014-05-14 15:06:37Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefActaTraitementsProduitTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.utils.DaoUtils;

/**
 * @author David Cossé
 */
public class RefActaTraitementsProduitTopiaDao extends AbstractRefActaTraitementsProduitTopiaDao<RefActaTraitementsProduit> {


    public Map<String, String> findAllTreatementCodesAndNames() {
        Map<String, String> treatementCodesAndNames = Maps.newLinkedHashMap();
        String hql = "SELECT DISTINCT" +
                " atp." + RefActaTraitementsProduit.PROPERTY_CODE_TRAITEMENT + "," + " atp." + RefActaTraitementsProduit.PROPERTY_NOM_TRAITEMENT +
                " FROM " + getEntityClass().getName() + " atp" +
                " where atp." + RefActaTraitementsProduit.PROPERTY_ACTIVE + " = true" +
                " GROUP BY atp." + RefActaTraitementsProduit.PROPERTY_CODE_TRAITEMENT + "," + " atp." + RefActaTraitementsProduit.PROPERTY_NOM_TRAITEMENT +
                " ORDER BY atp." + RefActaTraitementsProduit.PROPERTY_NOM_TRAITEMENT;

        Map<String, Object> map = Maps.newHashMap();
        List<Object[]> allByQuery = findAll(hql, map);
        for (Object[] treatment : allByQuery) {
            String key = (String) treatment[0];
            String value = (String) treatment[1];
            treatementCodesAndNames.put(key, value);
        }
        return treatementCodesAndNames;
    }

    public List<RefActaTraitementsProduit> findAllActiveTreatmentTypesForProductType(AgrosystInterventionType agrosystInterventionType, String productType) {
        Map<String, Object> args = DaoUtils.asArgsMap(
                "productType", productType,
                "acta_tpc_active", true,
                "acta_tp_active", true,
                "agrosystInterventionType", agrosystInterventionType);

        String query = " FROM " + getEntityClass().getName() + " acta_tp " +
                " WHERE acta_tp."+ RefActaTraitementsProduit.PROPERTY_ID_TRAITEMENT + " IN (" +
                "   SELECT acta_tpc." + RefActaTraitementsProduitsCateg.PROPERTY_ID_TRAITEMENT + " FROM " + RefActaTraitementsProduitsCateg.class.getName() + " acta_tpc " +
                "   WHERE acta_tpc." + RefActaTraitementsProduitsCateg.PROPERTY_TYPE_PRODUIT +" = :productType " +
                "   AND acta_tpc." + RefActaTraitementsProduitsCateg.PROPERTY_ACTIVE + " = :acta_tpc_active" +
                "   AND acta_tpc." + RefActaTraitementsProduitsCateg.PROPERTY_ACTION + " = :agrosystInterventionType)" +
                " AND acta_tp." + RefActaTraitementsProduit.PROPERTY_ACTIVE + " = :acta_tp_active " +
                " ORDER BY acta_tp." + RefActaTraitementsProduit.PROPERTY_NOM_PRODUIT;

        List<RefActaTraitementsProduit> result = findAll(query, args);

        return result;
    }
}
