package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefActaSubstanceActiveTopiaDao.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefActaSubstanceActiveTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class RefActaSubstanceActiveTopiaDao extends AbstractRefActaSubstanceActiveTopiaDao<RefActaSubstanceActive> {
    
    public List<RefActaSubstanceActive> findDistinctSubtanceActive() {
        String query = "FROM " + RefActaSubstanceActive.class.getName() + " SA" +
                " WHERE SA." + RefActaSubstanceActive.PROPERTY_ACTIVE + " = true" +
                " AND not exists( FROM " + RefActaSubstanceActive.class.getName() + " other" +
                "  WHERE SA." + RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA +
                "   = other." + RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA +
                "  AND SA != other )" +
                " ORDER BY SA." + RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA;

        List<RefActaSubstanceActive> result = findAll(query, DaoUtils.asArgsMap());
        return result;
    }

} //RefActaSubstanceActiveTopiaDao
