package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefActaDosageSPCTopiaDao.java 3840 2014-03-21 10:48:23Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefActaDosageSPCTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;
import java.util.Set;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class RefActaDosageSPCTopiaDao extends AbstractRefActaDosageSPCTopiaDao<RefActaDosageSPC> {

    public RefActaDosageSPC findMinimalValue(String phytoProductId, Set<Integer> actaSpeciesIds) {
        Map<String, Object> args = Maps.newHashMap();
        String hql = " FROM " + getEntityClass().getName() + " d " +
                " WHERE 1 = 1 ";
        hql += DaoUtils.andAttributeEquals("d", RefActaDosageSPC.PROPERTY_ACTIVE, args, true);
        hql += DaoUtils.andAttributeEquals("d", RefActaDosageSPC.PROPERTY_ID_PRODUIT, args, phytoProductId);
        hql += DaoUtils.andAttributeIn("d", RefActaDosageSPC.PROPERTY_ID_CULTURE, args, actaSpeciesIds);
        hql += " AND d." + RefActaDosageSPC.PROPERTY_DOSAGE_SPC_VALEUR + " IS NOT NULL ";

        String query = hql + " ORDER BY d." + RefActaDosageSPC.PROPERTY_DOSAGE_SPC_VALEUR + " ASC ";
        RefActaDosageSPC result = findFirstOrNull(query, args);
        return result;
    }

} //RefActaDosageSPCTopiaDao
