package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpecies;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpecies;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpeciesTopiaDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedRefVarieteTopiaDao<E extends RefVariete> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefVariete.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefVariete;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            CroppingPlanSpeciesTopiaDao dao = topiaDaoSupplier
                    .getDao(CroppingPlanSpecies.class, CroppingPlanSpeciesTopiaDao.class);
            List<CroppingPlanSpecies> list = dao
                    .forProperties(CroppingPlanSpecies.PROPERTY_VARIETY, entity)
                    .findAll();
            for (CroppingPlanSpecies item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getVariety())) {
                    item.setVariety(null);
                }
            
            }
        }

        {
            PracticedCropCycleSpeciesTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedCropCycleSpecies.class, PracticedCropCycleSpeciesTopiaDao.class);
            List<PracticedCropCycleSpecies> list = dao
                    .forProperties(PracticedCropCycleSpecies.PROPERTY_GRAFT_SUPPORT, entity)
                    .findAll();
            for (PracticedCropCycleSpecies item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGraftSupport())) {
                    item.setGraftSupport(null);
                }
            
            }
        }

        {
            EffectiveCropCycleSpeciesTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveCropCycleSpecies.class, EffectiveCropCycleSpeciesTopiaDao.class);
            List<EffectiveCropCycleSpecies> list = dao
                    .forProperties(EffectiveCropCycleSpecies.PROPERTY_GRAFT_SUPPORT, entity)
                    .findAll();
            for (EffectiveCropCycleSpecies item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGraftSupport())) {
                    item.setGraftSupport(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == PracticedCropCycleSpecies.class) {
            PracticedCropCycleSpeciesTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedCropCycleSpecies.class, PracticedCropCycleSpeciesTopiaDao.class);
            tmp = dao.forGraftSupportEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveCropCycleSpecies.class) {
            EffectiveCropCycleSpeciesTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveCropCycleSpecies.class, EffectiveCropCycleSpeciesTopiaDao.class);
            tmp = dao.forGraftSupportEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == CroppingPlanSpecies.class) {
            CroppingPlanSpeciesTopiaDao dao =
                topiaDaoSupplier.getDao(CroppingPlanSpecies.class, CroppingPlanSpeciesTopiaDao.class);
            tmp = dao.forVarietyEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(PracticedCropCycleSpecies.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedCropCycleSpecies.class, list);
        }

        list = findUsages(EffectiveCropCycleSpecies.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveCropCycleSpecies.class, list);
        }

        list = findUsages(CroppingPlanSpecies.class, entity);
        if (!list.isEmpty()) {
            result.put(CroppingPlanSpecies.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefVarieteTopiaDao<E extends RefVariete>
