package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.WeatherStation;
import fr.inra.agrosyst.api.entities.WeatherStationTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefStationMeteoTopiaDao<E extends RefStationMeteo> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefStationMeteo.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefStationMeteo;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            WeatherStationTopiaDao dao = topiaDaoSupplier
                    .getDao(WeatherStation.class, WeatherStationTopiaDao.class);
            List<WeatherStation> list = dao
                    .forProperties(WeatherStation.PROPERTY_REF_STATION_METEO, entity)
                    .findAll();
            for (WeatherStation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getRefStationMeteo())) {
                    item.setRefStationMeteo(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String affectation) {
        return forNaturalId(affectation).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String affectation) {
        return forNaturalId(affectation).exists();
    }

    public E createByNaturalId(String affectation) {
        return create(RefStationMeteo.PROPERTY_AFFECTATION, affectation);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String affectation) {
        return forProperties(RefStationMeteo.PROPERTY_AFFECTATION, affectation);
    }

    public E createByNotNull(String affectation) {
        return create(RefStationMeteo.PROPERTY_AFFECTATION, affectation);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommuneSiteIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStationMeteo.PROPERTY_COMMUNE_SITE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommuneSiteEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStationMeteo.PROPERTY_COMMUNE_SITE, v);
        return result;
    }

    @Deprecated
    public E findByCommuneSite(String v) {
        return forCommuneSiteEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCommuneSite(String v) {
        return forCommuneSiteEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodePostalIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStationMeteo.PROPERTY_CODE_POSTAL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodePostalEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStationMeteo.PROPERTY_CODE_POSTAL, v);
        return result;
    }

    @Deprecated
    public E findByCodePostal(String v) {
        return forCodePostalEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCodePostal(String v) {
        return forCodePostalEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommuneIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStationMeteo.PROPERTY_COMMUNE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommuneEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStationMeteo.PROPERTY_COMMUNE, v);
        return result;
    }

    @Deprecated
    public E findByCommune(String v) {
        return forCommuneEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCommune(String v) {
        return forCommuneEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSiteIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStationMeteo.PROPERTY_SITE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSiteEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStationMeteo.PROPERTY_SITE, v);
        return result;
    }

    @Deprecated
    public E findBySite(String v) {
        return forSiteEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySite(String v) {
        return forSiteEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAffectationIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStationMeteo.PROPERTY_AFFECTATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAffectationEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStationMeteo.PROPERTY_AFFECTATION, v);
        return result;
    }

    @Deprecated
    public E findByAffectation(String v) {
        return forAffectationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAffectation(String v) {
        return forAffectationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPointGPSIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStationMeteo.PROPERTY_POINT_GPS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPointGPSEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStationMeteo.PROPERTY_POINT_GPS, v);
        return result;
    }

    @Deprecated
    public E findByPointGPS(String v) {
        return forPointGPSEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPointGPS(String v) {
        return forPointGPSEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStationMeteo.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStationMeteo.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStationMeteo.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStationMeteo.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == WeatherStation.class) {
            WeatherStationTopiaDao dao =
                topiaDaoSupplier.getDao(WeatherStation.class, WeatherStationTopiaDao.class);
            tmp = dao.forRefStationMeteoEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(WeatherStation.class, entity);
        if (!list.isEmpty()) {
            result.put(WeatherStation.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefStationMeteoTopiaDao<E extends RefStationMeteo>
