package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.measure.Observation;
import fr.inra.agrosyst.api.entities.measure.ObservationTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStadeTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefStadeEDITopiaDao<E extends RefStadeEDI> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefStadeEDI.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefStadeEDI;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            EffectiveSpeciesStadeTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveSpeciesStade.class, EffectiveSpeciesStadeTopiaDao.class);
            List<EffectiveSpeciesStade> list = dao
                    .forProperties(EffectiveSpeciesStade.PROPERTY_MIN_STADE, entity)
                    .findAll();
            for (EffectiveSpeciesStade item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getMinStade())) {
                    item.setMinStade(null);
                }
            
            }
        }

        {
            EffectiveSpeciesStadeTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveSpeciesStade.class, EffectiveSpeciesStadeTopiaDao.class);
            List<EffectiveSpeciesStade> list = dao
                    .forProperties(EffectiveSpeciesStade.PROPERTY_MAX_STADE, entity)
                    .findAll();
            for (EffectiveSpeciesStade item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getMaxStade())) {
                    item.setMaxStade(null);
                }
            
            }
        }

        {
            ObservationTopiaDao dao = topiaDaoSupplier
                    .getDao(Observation.class, ObservationTopiaDao.class);
            List<Observation> list = dao
                    .forProperties(Observation.PROPERTY_CROP_STAGE_MIN, entity)
                    .findAll();
            for (Observation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCropStageMin())) {
                    item.setCropStageMin(null);
                }
            
            }
        }

        {
            ObservationTopiaDao dao = topiaDaoSupplier
                    .getDao(Observation.class, ObservationTopiaDao.class);
            List<Observation> list = dao
                    .forProperties(Observation.PROPERTY_CROP_STAGE_AVERAGE, entity)
                    .findAll();
            for (Observation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCropStageAverage())) {
                    item.setCropStageAverage(null);
                }
            
            }
        }

        {
            ObservationTopiaDao dao = topiaDaoSupplier
                    .getDao(Observation.class, ObservationTopiaDao.class);
            List<Observation> list = dao
                    .forProperties(Observation.PROPERTY_CROP_STAGE_MEDIUM, entity)
                    .findAll();
            for (Observation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCropStageMedium())) {
                    item.setCropStageMedium(null);
                }
            
            }
        }

        {
            ObservationTopiaDao dao = topiaDaoSupplier
                    .getDao(Observation.class, ObservationTopiaDao.class);
            List<Observation> list = dao
                    .forProperties(Observation.PROPERTY_CROP_STAGE_MAX, entity)
                    .findAll();
            for (Observation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCropStageMax())) {
                    item.setCropStageMax(null);
                }
            
            }
        }

        {
            ObservationTopiaDao dao = topiaDaoSupplier
                    .getDao(Observation.class, ObservationTopiaDao.class);
            List<Observation> list = dao
                    .forProperties(Observation.PROPERTY_ADVENTICE_STAGE, entity)
                    .findAll();
            for (Observation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getAdventiceStage())) {
                    item.setAdventiceStage(null);
                }
            
            }
        }

        {
            PracticedSpeciesStadeTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedSpeciesStade.class, PracticedSpeciesStadeTopiaDao.class);
            List<PracticedSpeciesStade> list = dao
                    .forProperties(PracticedSpeciesStade.PROPERTY_STADE_MIN, entity)
                    .findAll();
            for (PracticedSpeciesStade item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getStadeMin())) {
                    item.setStadeMin(null);
                }
            
            }
        }

        {
            PracticedSpeciesStadeTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedSpeciesStade.class, PracticedSpeciesStadeTopiaDao.class);
            List<PracticedSpeciesStade> list = dao
                    .forProperties(PracticedSpeciesStade.PROPERTY_STADE_MAX, entity)
                    .findAll();
            for (PracticedSpeciesStade item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getStadeMax())) {
                    item.setStadeMax(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String aee) {
        return forNaturalId(aee).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String aee) {
        return forNaturalId(aee).exists();
    }

    public E createByNaturalId(String aee) {
        return create(RefStadeEDI.PROPERTY_AEE, aee);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String aee) {
        return forProperties(RefStadeEDI.PROPERTY_AEE, aee);
    }

    public E createByNotNull(String aee) {
        return create(RefStadeEDI.PROPERTY_AEE, aee);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFamille_de_cultureIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_FAMILLE_DE_CULTURE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFamille_de_cultureEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_FAMILLE_DE_CULTURE, v);
        return result;
    }

    @Deprecated
    public E findByFamille_de_culture(String v) {
        return forFamille_de_cultureEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFamille_de_culture(String v) {
        return forFamille_de_cultureEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSecond_nIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_SECOND_N, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSecond_nEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_SECOND_N, v);
        return result;
    }

    @Deprecated
    public E findBySecond_n(Integer v) {
        return forSecond_nEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySecond_n(Integer v) {
        return forSecond_nEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forThird_nIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_THIRD_N, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forThird_nEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_THIRD_N, v);
        return result;
    }

    @Deprecated
    public E findByThird_n(Integer v) {
        return forThird_nEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByThird_n(Integer v) {
        return forThird_nEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFourth_nIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_FOURTH_N, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFourth_nEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_FOURTH_N, v);
        return result;
    }

    @Deprecated
    public E findByFourth_n(Integer v) {
        return forFourth_nEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFourth_n(Integer v) {
        return forFourth_nEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forColonne1In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_COLONNE1, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forColonne1Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_COLONNE1, v);
        return result;
    }

    @Deprecated
    public E findByColonne1(String v) {
        return forColonne1Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByColonne1(String v) {
        return forColonne1Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStade_autreIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_STADE_AUTRE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStade_autreEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_STADE_AUTRE, v);
        return result;
    }

    @Deprecated
    public E findByStade_autre(String v) {
        return forStade_autreEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStade_autre(String v) {
        return forStade_autreEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStade_producteurIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_STADE_PRODUCTEUR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStade_producteurEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_STADE_PRODUCTEUR, v);
        return result;
    }

    @Deprecated
    public E findByStade_producteur(String v) {
        return forStade_producteurEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStade_producteur(String v) {
        return forStade_producteurEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodes_familles_AGRICOMMANDIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_CODES_FAMILLES__AGRICOMMAND, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodes_familles_AGRICOMMANDEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_CODES_FAMILLES__AGRICOMMAND, v);
        return result;
    }

    @Deprecated
    public E findByCodes_familles_AGRICOMMAND(Integer v) {
        return forCodes_familles_AGRICOMMANDEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCodes_familles_AGRICOMMAND(Integer v) {
        return forCodes_familles_AGRICOMMANDEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProfil_vegetatifIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_PROFIL_VEGETATIF, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProfil_vegetatifEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_PROFIL_VEGETATIF, v);
        return result;
    }

    @Deprecated
    public E findByProfil_vegetatif(Integer v) {
        return forProfil_vegetatifEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProfil_vegetatif(Integer v) {
        return forProfil_vegetatifEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAeeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_AEE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAeeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_AEE, v);
        return result;
    }

    @Deprecated
    public E findByAee(String v) {
        return forAeeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAee(String v) {
        return forAeeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forColonne2In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_COLONNE2, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forColonne2Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_COLONNE2, v);
        return result;
    }

    @Deprecated
    public E findByColonne2(String v) {
        return forColonne2Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByColonne2(String v) {
        return forColonne2Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlages_de_stades_retenues_libellesIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_PLAGES_DE_STADES_RETENUES_LIBELLES, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlages_de_stades_retenues_libellesEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_PLAGES_DE_STADES_RETENUES_LIBELLES, v);
        return result;
    }

    @Deprecated
    public E findByPlages_de_stades_retenues_libelles(String v) {
        return forPlages_de_stades_retenues_libellesEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlages_de_stades_retenues_libelles(String v) {
        return forPlages_de_stades_retenues_libellesEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProposition_APCAIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_PROPOSITION__APCA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProposition_APCAEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_PROPOSITION__APCA, v);
        return result;
    }

    @Deprecated
    public E findByProposition_APCA(String v) {
        return forProposition_APCAEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProposition_APCA(String v) {
        return forProposition_APCAEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProposition_DGAL_Vigne_et_bleIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_PROPOSITION__DGAL__VIGNE_ET_BLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProposition_DGAL_Vigne_et_bleEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_PROPOSITION__DGAL__VIGNE_ET_BLE, v);
        return result;
    }

    @Deprecated
    public E findByProposition_DGAL_Vigne_et_ble(String v) {
        return forProposition_DGAL_Vigne_et_bleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProposition_DGAL_Vigne_et_ble(String v) {
        return forProposition_DGAL_Vigne_et_bleEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forArvalis_vs_actaIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_ARVALIS_VS_ACTA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forArvalis_vs_actaEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_ARVALIS_VS_ACTA, v);
        return result;
    }

    @Deprecated
    public E findByArvalis_vs_acta(String v) {
        return forArvalis_vs_actaEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByArvalis_vs_acta(String v) {
        return forArvalis_vs_actaEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLibelle_court_institut_du_LinIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_LIBELLE_COURT_INSTITUT_DU__LIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLibelle_court_institut_du_LinEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_LIBELLE_COURT_INSTITUT_DU__LIN, v);
        return result;
    }

    @Deprecated
    public E findByLibelle_court_institut_du_Lin(String v) {
        return forLibelle_court_institut_du_LinEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLibelle_court_institut_du_Lin(String v) {
        return forLibelle_court_institut_du_LinEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefStadeEDI.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefStadeEDI.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == PracticedSpeciesStade.class) {
            PracticedSpeciesStadeTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedSpeciesStade.class, PracticedSpeciesStadeTopiaDao.class);
            tmp = dao.forStadeMinEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == PracticedSpeciesStade.class) {
            PracticedSpeciesStadeTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedSpeciesStade.class, PracticedSpeciesStadeTopiaDao.class);
            tmp = dao.forStadeMaxEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveSpeciesStade.class) {
            EffectiveSpeciesStadeTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveSpeciesStade.class, EffectiveSpeciesStadeTopiaDao.class);
            tmp = dao.forMinStadeEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveSpeciesStade.class) {
            EffectiveSpeciesStadeTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveSpeciesStade.class, EffectiveSpeciesStadeTopiaDao.class);
            tmp = dao.forMaxStadeEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Observation.class) {
            ObservationTopiaDao dao =
                topiaDaoSupplier.getDao(Observation.class, ObservationTopiaDao.class);
            tmp = dao.forCropStageMinEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Observation.class) {
            ObservationTopiaDao dao =
                topiaDaoSupplier.getDao(Observation.class, ObservationTopiaDao.class);
            tmp = dao.forCropStageAverageEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Observation.class) {
            ObservationTopiaDao dao =
                topiaDaoSupplier.getDao(Observation.class, ObservationTopiaDao.class);
            tmp = dao.forCropStageMediumEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Observation.class) {
            ObservationTopiaDao dao =
                topiaDaoSupplier.getDao(Observation.class, ObservationTopiaDao.class);
            tmp = dao.forCropStageMaxEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Observation.class) {
            ObservationTopiaDao dao =
                topiaDaoSupplier.getDao(Observation.class, ObservationTopiaDao.class);
            tmp = dao.forAdventiceStageEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(PracticedSpeciesStade.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedSpeciesStade.class, list);
        }

        list = findUsages(EffectiveSpeciesStade.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveSpeciesStade.class, list);
        }

        list = findUsages(Observation.class, entity);
        if (!list.isEmpty()) {
            result.put(Observation.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefStadeEDITopiaDao<E extends RefStadeEDI>
