package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.BasicPlot;
import fr.inra.agrosyst.api.entities.BasicPlotTopiaDao;
import fr.inra.agrosyst.api.entities.SolHorizon;
import fr.inra.agrosyst.api.entities.SolHorizonTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefSolTextureGeppaTopiaDao<E extends RefSolTextureGeppa> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefSolTextureGeppa.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefSolTextureGeppa;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            BasicPlotTopiaDao dao = topiaDaoSupplier
                    .getDao(BasicPlot.class, BasicPlotTopiaDao.class);
            List<BasicPlot> list = dao
                    .forProperties(BasicPlot.PROPERTY_SURFACE_TEXTURE, entity)
                    .findAll();
            for (BasicPlot item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSurfaceTexture())) {
                    item.setSurfaceTexture(null);
                }
            
            }
        }

        {
            SolHorizonTopiaDao dao = topiaDaoSupplier
                    .getDao(SolHorizon.class, SolHorizonTopiaDao.class);
            List<SolHorizon> list = dao
                    .forProperties(SolHorizon.PROPERTY_SOL_TEXTURE, entity)
                    .findAll();
            for (SolHorizon item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSolTexture())) {
                    item.setSolTexture(null);
                }
            
            }
        }

        {
            BasicPlotTopiaDao dao = topiaDaoSupplier
                    .getDao(BasicPlot.class, BasicPlotTopiaDao.class);
            List<BasicPlot> list = dao
                    .forProperties(BasicPlot.PROPERTY_SUB_SOIL_TEXTURE, entity)
                    .findAll();
            for (BasicPlot item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSubSoilTexture())) {
                    item.setSubSoilTexture(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String abbreviation_classes_texturales_GEPAA) {
        return forNaturalId(abbreviation_classes_texturales_GEPAA).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String abbreviation_classes_texturales_GEPAA) {
        return forNaturalId(abbreviation_classes_texturales_GEPAA).exists();
    }

    public E createByNaturalId(String abbreviation_classes_texturales_GEPAA) {
        return create(RefSolTextureGeppa.PROPERTY_ABBREVIATION_CLASSES_TEXTURALES__GEPAA, abbreviation_classes_texturales_GEPAA);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String abbreviation_classes_texturales_GEPAA) {
        return forProperties(RefSolTextureGeppa.PROPERTY_ABBREVIATION_CLASSES_TEXTURALES__GEPAA, abbreviation_classes_texturales_GEPAA);
    }

    public E createByNotNull(String abbreviation_classes_texturales_GEPAA, String classes_texturales_GEPAA, String abbreviation_INDIGO, String classe_INDIGO) {
        return create(RefSolTextureGeppa.PROPERTY_ABBREVIATION_CLASSES_TEXTURALES__GEPAA, abbreviation_classes_texturales_GEPAA, RefSolTextureGeppa.PROPERTY_CLASSES_TEXTURALES__GEPAA, classes_texturales_GEPAA, RefSolTextureGeppa.PROPERTY_ABBREVIATION__INDIGO, abbreviation_INDIGO, RefSolTextureGeppa.PROPERTY_CLASSE__INDIGO, classe_INDIGO);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAbbreviation_classes_texturales_GEPAAIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolTextureGeppa.PROPERTY_ABBREVIATION_CLASSES_TEXTURALES__GEPAA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAbbreviation_classes_texturales_GEPAAEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolTextureGeppa.PROPERTY_ABBREVIATION_CLASSES_TEXTURALES__GEPAA, v);
        return result;
    }

    @Deprecated
    public E findByAbbreviation_classes_texturales_GEPAA(String v) {
        return forAbbreviation_classes_texturales_GEPAAEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAbbreviation_classes_texturales_GEPAA(String v) {
        return forAbbreviation_classes_texturales_GEPAAEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasses_texturales_GEPAAIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolTextureGeppa.PROPERTY_CLASSES_TEXTURALES__GEPAA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasses_texturales_GEPAAEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolTextureGeppa.PROPERTY_CLASSES_TEXTURALES__GEPAA, v);
        return result;
    }

    @Deprecated
    public E findByClasses_texturales_GEPAA(String v) {
        return forClasses_texturales_GEPAAEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByClasses_texturales_GEPAA(String v) {
        return forClasses_texturales_GEPAAEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAbbreviation_INDIGOIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolTextureGeppa.PROPERTY_ABBREVIATION__INDIGO, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAbbreviation_INDIGOEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolTextureGeppa.PROPERTY_ABBREVIATION__INDIGO, v);
        return result;
    }

    @Deprecated
    public E findByAbbreviation_INDIGO(String v) {
        return forAbbreviation_INDIGOEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAbbreviation_INDIGO(String v) {
        return forAbbreviation_INDIGOEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_INDIGOIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolTextureGeppa.PROPERTY_CLASSE__INDIGO, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_INDIGOEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolTextureGeppa.PROPERTY_CLASSE__INDIGO, v);
        return result;
    }

    @Deprecated
    public E findByClasse_INDIGO(String v) {
        return forClasse_INDIGOEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByClasse_INDIGO(String v) {
        return forClasse_INDIGOEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTexture_iphyIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolTextureGeppa.PROPERTY_TEXTURE_IPHY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTexture_iphyEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolTextureGeppa.PROPERTY_TEXTURE_IPHY, v);
        return result;
    }

    @Deprecated
    public E findByTexture_iphy(String v) {
        return forTexture_iphyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTexture_iphy(String v) {
        return forTexture_iphyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolTextureGeppa.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolTextureGeppa.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolTextureGeppa.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolTextureGeppa.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == SolHorizon.class) {
            SolHorizonTopiaDao dao =
                topiaDaoSupplier.getDao(SolHorizon.class, SolHorizonTopiaDao.class);
            tmp = dao.forSolTextureEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == BasicPlot.class) {
            BasicPlotTopiaDao dao =
                topiaDaoSupplier.getDao(BasicPlot.class, BasicPlotTopiaDao.class);
            tmp = dao.forSurfaceTextureEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == BasicPlot.class) {
            BasicPlotTopiaDao dao =
                topiaDaoSupplier.getDao(BasicPlot.class, BasicPlotTopiaDao.class);
            tmp = dao.forSubSoilTextureEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(SolHorizon.class, entity);
        if (!list.isEmpty()) {
            result.put(SolHorizon.class, list);
        }

        list = findUsages(BasicPlot.class, entity);
        if (!list.isEmpty()) {
            result.put(BasicPlot.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefSolTextureGeppaTopiaDao<E extends RefSolTextureGeppa>
