package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.BasicPlot;
import fr.inra.agrosyst.api.entities.BasicPlotTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedRefSolProfondeurIndigoTopiaDao<E extends RefSolProfondeurIndigo> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefSolProfondeurIndigo.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefSolProfondeurIndigo;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            BasicPlotTopiaDao dao = topiaDaoSupplier
                    .getDao(BasicPlot.class, BasicPlotTopiaDao.class);
            List<BasicPlot> list = dao
                    .forProperties(BasicPlot.PROPERTY_SOL_DEPTH, entity)
                    .findAll();
            for (BasicPlot item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSolDepth())) {
                    item.setSolDepth(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String classe_de_profondeur_INDIGO) {
        return forNaturalId(classe_de_profondeur_INDIGO).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String classe_de_profondeur_INDIGO) {
        return forNaturalId(classe_de_profondeur_INDIGO).exists();
    }

    public E createByNaturalId(String classe_de_profondeur_INDIGO) {
        return create(RefSolProfondeurIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO, classe_de_profondeur_INDIGO);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String classe_de_profondeur_INDIGO) {
        return forProperties(RefSolProfondeurIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO, classe_de_profondeur_INDIGO);
    }

    public E createByNotNull(String classe_de_profondeur_INDIGO, String profondeur, String libelle_classe, int profondeur_par_defaut) {
        return create(RefSolProfondeurIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO, classe_de_profondeur_INDIGO, RefSolProfondeurIndigo.PROPERTY_PROFONDEUR, profondeur, RefSolProfondeurIndigo.PROPERTY_LIBELLE_CLASSE, libelle_classe, RefSolProfondeurIndigo.PROPERTY_PROFONDEUR_PAR_DEFAUT, profondeur_par_defaut);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_de_profondeur_INDIGOIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolProfondeurIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_de_profondeur_INDIGOEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolProfondeurIndigo.PROPERTY_CLASSE_DE_PROFONDEUR__INDIGO, v);
        return result;
    }

    @Deprecated
    public E findByClasse_de_profondeur_INDIGO(String v) {
        return forClasse_de_profondeur_INDIGOEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByClasse_de_profondeur_INDIGO(String v) {
        return forClasse_de_profondeur_INDIGOEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProfondeurIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolProfondeurIndigo.PROPERTY_PROFONDEUR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProfondeurEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolProfondeurIndigo.PROPERTY_PROFONDEUR, v);
        return result;
    }

    @Deprecated
    public E findByProfondeur(String v) {
        return forProfondeurEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProfondeur(String v) {
        return forProfondeurEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLibelle_classeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolProfondeurIndigo.PROPERTY_LIBELLE_CLASSE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLibelle_classeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolProfondeurIndigo.PROPERTY_LIBELLE_CLASSE, v);
        return result;
    }

    @Deprecated
    public E findByLibelle_classe(String v) {
        return forLibelle_classeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLibelle_classe(String v) {
        return forLibelle_classeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProfondeur_par_defautIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolProfondeurIndigo.PROPERTY_PROFONDEUR_PAR_DEFAUT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProfondeur_par_defautEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolProfondeurIndigo.PROPERTY_PROFONDEUR_PAR_DEFAUT, v);
        return result;
    }

    @Deprecated
    public E findByProfondeur_par_defaut(int v) {
        return forProfondeur_par_defautEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProfondeur_par_defaut(int v) {
        return forProfondeur_par_defautEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolProfondeurIndigo.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolProfondeurIndigo.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefSolProfondeurIndigo.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefSolProfondeurIndigo.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == BasicPlot.class) {
            BasicPlotTopiaDao dao =
                topiaDaoSupplier.getDao(BasicPlot.class, BasicPlotTopiaDao.class);
            tmp = dao.forSolDepthEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(BasicPlot.class, entity);
        if (!list.isEmpty()) {
            result.put(BasicPlot.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefSolProfondeurIndigoTopiaDao<E extends RefSolProfondeurIndigo>
