package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.measure.Observation;
import fr.inra.agrosyst.api.entities.measure.ObservationTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefProtocoleVgObsTopiaDao<E extends RefProtocoleVgObs> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefProtocoleVgObs.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefProtocoleVgObs;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            ObservationTopiaDao dao = topiaDaoSupplier
                    .getDao(Observation.class, ObservationTopiaDao.class);
            List<Observation> list = dao
                    .forProperties(Observation.PROPERTY_PROTOCOL, entity)
                    .findAll();
            for (Observation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getProtocol())) {
                    item.setProtocol(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String protocole_code_protocole, String ligne_code_ligne_protocole, String releve_no_releve, String releve_qualifiant_unite_mesure_code, String classe_no_classe) {
        return forNaturalId(protocole_code_protocole, ligne_code_ligne_protocole, releve_no_releve, releve_qualifiant_unite_mesure_code, classe_no_classe).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String protocole_code_protocole, String ligne_code_ligne_protocole, String releve_no_releve, String releve_qualifiant_unite_mesure_code, String classe_no_classe) {
        return forNaturalId(protocole_code_protocole, ligne_code_ligne_protocole, releve_no_releve, releve_qualifiant_unite_mesure_code, classe_no_classe).exists();
    }

    public E createByNaturalId(String protocole_code_protocole, String ligne_code_ligne_protocole, String releve_no_releve, String releve_qualifiant_unite_mesure_code, String classe_no_classe) {
        return create(RefProtocoleVgObs.PROPERTY_PROTOCOLE_CODE_PROTOCOLE, protocole_code_protocole, RefProtocoleVgObs.PROPERTY_LIGNE_CODE_LIGNE_PROTOCOLE, ligne_code_ligne_protocole, RefProtocoleVgObs.PROPERTY_RELEVE_NO_RELEVE, releve_no_releve, RefProtocoleVgObs.PROPERTY_RELEVE_QUALIFIANT_UNITE_MESURE_CODE, releve_qualifiant_unite_mesure_code, RefProtocoleVgObs.PROPERTY_CLASSE_NO_CLASSE, classe_no_classe);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String protocole_code_protocole, String ligne_code_ligne_protocole, String releve_no_releve, String releve_qualifiant_unite_mesure_code, String classe_no_classe) {
        return forProperties(RefProtocoleVgObs.PROPERTY_PROTOCOLE_CODE_PROTOCOLE, protocole_code_protocole, RefProtocoleVgObs.PROPERTY_LIGNE_CODE_LIGNE_PROTOCOLE, ligne_code_ligne_protocole, RefProtocoleVgObs.PROPERTY_RELEVE_NO_RELEVE, releve_no_releve, RefProtocoleVgObs.PROPERTY_RELEVE_QUALIFIANT_UNITE_MESURE_CODE, releve_qualifiant_unite_mesure_code, RefProtocoleVgObs.PROPERTY_CLASSE_NO_CLASSE, classe_no_classe);
    }

    public E createByNotNull(String protocole_code_protocole, String ligne_code_ligne_protocole, String releve_no_releve) {
        return create(RefProtocoleVgObs.PROPERTY_PROTOCOLE_CODE_PROTOCOLE, protocole_code_protocole, RefProtocoleVgObs.PROPERTY_LIGNE_CODE_LIGNE_PROTOCOLE, ligne_code_ligne_protocole, RefProtocoleVgObs.PROPERTY_RELEVE_NO_RELEVE, releve_no_releve);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_code_protocoleIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_CODE_PROTOCOLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_code_protocoleEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_CODE_PROTOCOLE, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_code_protocole(String v) {
        return forProtocole_code_protocoleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_code_protocole(String v) {
        return forProtocole_code_protocoleEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_libelleIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_LIBELLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_libelleEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_LIBELLE, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_libelle(String v) {
        return forProtocole_libelleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_libelle(String v) {
        return forProtocole_libelleEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_statut_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_STATUT_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_statut_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_STATUT_CODE, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_statut_code(String v) {
        return forProtocole_statut_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_statut_code(String v) {
        return forProtocole_statut_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_statutIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_STATUT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_statutEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_STATUT, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_statut(String v) {
        return forProtocole_statutEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_statut(String v) {
        return forProtocole_statutEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_statue_leIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_STATUE_LE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_statue_leEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_STATUE_LE, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_statue_le(String v) {
        return forProtocole_statue_leEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_statue_le(String v) {
        return forProtocole_statue_leEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_modifie_leIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_MODIFIE_LE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_modifie_leEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_MODIFIE_LE, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_modifie_le(String v) {
        return forProtocole_modifie_leEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_modifie_le(String v) {
        return forProtocole_modifie_leEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_valide_leIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_VALIDE_LE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_valide_leEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_VALIDE_LE, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_valide_le(String v) {
        return forProtocole_valide_leEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_valide_le(String v) {
        return forProtocole_valide_leEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_statue_parIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_STATUE_PAR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_statue_parEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_STATUE_PAR, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_statue_par(String v) {
        return forProtocole_statue_parEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_statue_par(String v) {
        return forProtocole_statue_parEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_modifie_parIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_MODIFIE_PAR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_modifie_parEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_MODIFIE_PAR, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_modifie_par(String v) {
        return forProtocole_modifie_parEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_modifie_par(String v) {
        return forProtocole_modifie_parEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_valide_parIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_VALIDE_PAR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_valide_parEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_VALIDE_PAR, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_valide_par(String v) {
        return forProtocole_valide_parEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_valide_par(String v) {
        return forProtocole_valide_parEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_culturesIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_PROTOCOLE_CULTURES, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProtocole_culturesEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_PROTOCOLE_CULTURES, v);
        return result;
    }

    @Deprecated
    public E findByProtocole_cultures(String v) {
        return forProtocole_culturesEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProtocole_cultures(String v) {
        return forProtocole_culturesEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_numero_ordreIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_NUMERO_ORDRE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_numero_ordreEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_NUMERO_ORDRE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_numero_ordre(int v) {
        return forLigne_numero_ordreEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_numero_ordre(int v) {
        return forLigne_numero_ordreEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_numero_ligneIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_NUMERO_LIGNE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_numero_ligneEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_NUMERO_LIGNE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_numero_ligne(int v) {
        return forLigne_numero_ligneEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_numero_ligne(int v) {
        return forLigne_numero_ligneEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_code_ligne_protocoleIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_CODE_LIGNE_PROTOCOLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_code_ligne_protocoleEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_CODE_LIGNE_PROTOCOLE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_code_ligne_protocole(String v) {
        return forLigne_code_ligne_protocoleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_code_ligne_protocole(String v) {
        return forLigne_code_ligne_protocoleEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_organisme_vivant_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_ORGANISME_VIVANT_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_organisme_vivant_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_ORGANISME_VIVANT_CODE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_organisme_vivant_code(String v) {
        return forLigne_organisme_vivant_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_organisme_vivant_code(String v) {
        return forLigne_organisme_vivant_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_organisme_vivantIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_ORGANISME_VIVANT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_organisme_vivantEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_ORGANISME_VIVANT, v);
        return result;
    }

    @Deprecated
    public E findByLigne_organisme_vivant(String v) {
        return forLigne_organisme_vivantEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_organisme_vivant(String v) {
        return forLigne_organisme_vivantEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stades_developpementIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_STADES_DEVELOPPEMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stades_developpementEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_STADES_DEVELOPPEMENT, v);
        return result;
    }

    @Deprecated
    public E findByLigne_stades_developpement(String v) {
        return forLigne_stades_developpementEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_stades_developpement(String v) {
        return forLigne_stades_developpementEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stade_pheno_initial_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_STADE_PHENO_INITIAL_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stade_pheno_initial_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_STADE_PHENO_INITIAL_CODE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_stade_pheno_initial_code(String v) {
        return forLigne_stade_pheno_initial_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_stade_pheno_initial_code(String v) {
        return forLigne_stade_pheno_initial_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stade_pheno_initialIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_STADE_PHENO_INITIAL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stade_pheno_initialEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_STADE_PHENO_INITIAL, v);
        return result;
    }

    @Deprecated
    public E findByLigne_stade_pheno_initial(String v) {
        return forLigne_stade_pheno_initialEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_stade_pheno_initial(String v) {
        return forLigne_stade_pheno_initialEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stade_pheno_final_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_STADE_PHENO_FINAL_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stade_pheno_final_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_STADE_PHENO_FINAL_CODE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_stade_pheno_final_code(String v) {
        return forLigne_stade_pheno_final_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_stade_pheno_final_code(String v) {
        return forLigne_stade_pheno_final_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stade_pheno_finalIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_STADE_PHENO_FINAL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_stade_pheno_finalEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_STADE_PHENO_FINAL, v);
        return result;
    }

    @Deprecated
    public E findByLigne_stade_pheno_final(String v) {
        return forLigne_stade_pheno_finalEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_stade_pheno_final(String v) {
        return forLigne_stade_pheno_finalEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_debutIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_DEBUT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_debutEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_DEBUT, v);
        return result;
    }

    @Deprecated
    public E findByLigne_debut(String v) {
        return forLigne_debutEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_debut(String v) {
        return forLigne_debutEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_finIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_FIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_finEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_FIN, v);
        return result;
    }

    @Deprecated
    public E findByLigne_fin(String v) {
        return forLigne_finEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_fin(String v) {
        return forLigne_finEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_frequenceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_FREQUENCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_frequenceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_FREQUENCE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_frequence(String v) {
        return forLigne_frequenceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_frequence(String v) {
        return forLigne_frequenceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_supports_organesIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_SUPPORTS_ORGANES, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_supports_organesEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_SUPPORTS_ORGANES, v);
        return result;
    }

    @Deprecated
    public E findByLigne_supports_organes(String v) {
        return forLigne_supports_organesEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_supports_organes(String v) {
        return forLigne_supports_organesEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_piegesIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_PIEGES, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_piegesEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_PIEGES, v);
        return result;
    }

    @Deprecated
    public E findByLigne_pieges(String v) {
        return forLigne_piegesEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_pieges(String v) {
        return forLigne_piegesEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_type_echant_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_ECHANT_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_type_echant_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_ECHANT_CODE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_type_echant_code(String v) {
        return forLigne_type_echant_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_type_echant_code(String v) {
        return forLigne_type_echant_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_type_echantIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_ECHANT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_type_echantEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_ECHANT, v);
        return result;
    }

    @Deprecated
    public E findByLigne_type_echant(String v) {
        return forLigne_type_echantEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_type_echant(String v) {
        return forLigne_type_echantEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_echantillonnageIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_ECHANTILLONNAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_echantillonnageEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_ECHANTILLONNAGE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_echantillonnage(String v) {
        return forLigne_echantillonnageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_echantillonnage(String v) {
        return forLigne_echantillonnageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_type_observation_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_OBSERVATION_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_type_observation_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_OBSERVATION_CODE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_type_observation_code(String v) {
        return forLigne_type_observation_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_type_observation_code(String v) {
        return forLigne_type_observation_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_type_observationIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_OBSERVATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_type_observationEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_OBSERVATION, v);
        return result;
    }

    @Deprecated
    public E findByLigne_type_observation(String v) {
        return forLigne_type_observationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_type_observation(String v) {
        return forLigne_type_observationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_mode_operatoireIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_LIGNE_MODE_OPERATOIRE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLigne_mode_operatoireEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_LIGNE_MODE_OPERATOIRE, v);
        return result;
    }

    @Deprecated
    public E findByLigne_mode_operatoire(String v) {
        return forLigne_mode_operatoireEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLigne_mode_operatoire(String v) {
        return forLigne_mode_operatoireEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_no_releveIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_NO_RELEVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_no_releveEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_NO_RELEVE, v);
        return result;
    }

    @Deprecated
    public E findByReleve_no_releve(String v) {
        return forReleve_no_releveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_no_releve(String v) {
        return forReleve_no_releveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_type_releveIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_TYPE_RELEVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_type_releveEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_TYPE_RELEVE, v);
        return result;
    }

    @Deprecated
    public E findByReleve_type_releve(String v) {
        return forReleve_type_releveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_type_releve(String v) {
        return forReleve_type_releveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_unite_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_UNITE_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_unite_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_UNITE_CODE, v);
        return result;
    }

    @Deprecated
    public E findByReleve_unite_code(String v) {
        return forReleve_unite_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_unite_code(String v) {
        return forReleve_unite_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_uniteIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_UNITE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_uniteEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_UNITE, v);
        return result;
    }

    @Deprecated
    public E findByReleve_unite(String v) {
        return forReleve_uniteEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_unite(String v) {
        return forReleve_uniteEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_qualifiant_unite_mesure_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_QUALIFIANT_UNITE_MESURE_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_qualifiant_unite_mesure_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_QUALIFIANT_UNITE_MESURE_CODE, v);
        return result;
    }

    @Deprecated
    public E findByReleve_qualifiant_unite_mesure_code(String v) {
        return forReleve_qualifiant_unite_mesure_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_qualifiant_unite_mesure_code(String v) {
        return forReleve_qualifiant_unite_mesure_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_qualifiant_unite_mesureIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_QUALIFIANT_UNITE_MESURE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_qualifiant_unite_mesureEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_QUALIFIANT_UNITE_MESURE, v);
        return result;
    }

    @Deprecated
    public E findByReleve_qualifiant_unite_mesure(String v) {
        return forReleve_qualifiant_unite_mesureEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_qualifiant_unite_mesure(String v) {
        return forReleve_qualifiant_unite_mesureEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_valeur_qualitative_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_VALEUR_QUALITATIVE_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_valeur_qualitative_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_VALEUR_QUALITATIVE_CODE, v);
        return result;
    }

    @Deprecated
    public E findByReleve_valeur_qualitative_code(String v) {
        return forReleve_valeur_qualitative_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_valeur_qualitative_code(String v) {
        return forReleve_valeur_qualitative_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_valeur_qualitativeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_VALEUR_QUALITATIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_valeur_qualitativeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_VALEUR_QUALITATIVE, v);
        return result;
    }

    @Deprecated
    public E findByReleve_valeur_qualitative(String v) {
        return forReleve_valeur_qualitativeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_valeur_qualitative(String v) {
        return forReleve_valeur_qualitativeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_borne_minIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_BORNE_MIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_borne_minEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_BORNE_MIN, v);
        return result;
    }

    @Deprecated
    public E findByReleve_borne_min(String v) {
        return forReleve_borne_minEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_borne_min(String v) {
        return forReleve_borne_minEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_borne_maxIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_RELEVE_BORNE_MAX, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReleve_borne_maxEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_RELEVE_BORNE_MAX, v);
        return result;
    }

    @Deprecated
    public E findByReleve_borne_max(String v) {
        return forReleve_borne_maxEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReleve_borne_max(String v) {
        return forReleve_borne_maxEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_no_classeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_CLASSE_NO_CLASSE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_no_classeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_CLASSE_NO_CLASSE, v);
        return result;
    }

    @Deprecated
    public E findByClasse_no_classe(String v) {
        return forClasse_no_classeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByClasse_no_classe(String v) {
        return forClasse_no_classeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_valeur_qualitative_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_CLASSE_VALEUR_QUALITATIVE_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_valeur_qualitative_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_CLASSE_VALEUR_QUALITATIVE_CODE, v);
        return result;
    }

    @Deprecated
    public E findByClasse_valeur_qualitative_code(String v) {
        return forClasse_valeur_qualitative_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByClasse_valeur_qualitative_code(String v) {
        return forClasse_valeur_qualitative_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_valeur_qualitativeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_CLASSE_VALEUR_QUALITATIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forClasse_valeur_qualitativeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_CLASSE_VALEUR_QUALITATIVE, v);
        return result;
    }

    @Deprecated
    public E findByClasse_valeur_qualitative(String v) {
        return forClasse_valeur_qualitativeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByClasse_valeur_qualitative(String v) {
        return forClasse_valeur_qualitativeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefProtocoleVgObs.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefProtocoleVgObs.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Observation.class) {
            ObservationTopiaDao dao =
                topiaDaoSupplier.getDao(Observation.class, ObservationTopiaDao.class);
            tmp = dao.forProtocolEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Observation.class, entity);
        if (!list.isEmpty()) {
            result.put(Observation.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefProtocoleVgObsTopiaDao<E extends RefProtocoleVgObs>
