package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.measure.Measure;
import fr.inra.agrosyst.api.entities.measure.MeasureTopiaDao;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefMesureTopiaDao<E extends RefMesure> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefMesure.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefMesure;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            MeasureTopiaDao dao = topiaDaoSupplier
                    .getDao(Measure.class, MeasureTopiaDao.class);
            List<Measure> list = dao
                    .forProperties(Measure.PROPERTY_REF_MESURE, entity)
                    .findAll();
            for (Measure item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getRefMesure())) {
                    item.setRefMesure(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String variable_mesuree, MeasurementType categorie_de_mesure, VariableType type_variable_mesuree) {
        return forNaturalId(variable_mesuree, categorie_de_mesure, type_variable_mesuree).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String variable_mesuree, MeasurementType categorie_de_mesure, VariableType type_variable_mesuree) {
        return forNaturalId(variable_mesuree, categorie_de_mesure, type_variable_mesuree).exists();
    }

    public E createByNaturalId(String variable_mesuree, MeasurementType categorie_de_mesure, VariableType type_variable_mesuree) {
        return create(RefMesure.PROPERTY_VARIABLE_MESUREE, variable_mesuree, RefMesure.PROPERTY_CATEGORIE_DE_MESURE, categorie_de_mesure, RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, type_variable_mesuree);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String variable_mesuree, MeasurementType categorie_de_mesure, VariableType type_variable_mesuree) {
        return forProperties(RefMesure.PROPERTY_VARIABLE_MESUREE, variable_mesuree, RefMesure.PROPERTY_CATEGORIE_DE_MESURE, categorie_de_mesure, RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, type_variable_mesuree);
    }

    public E createByNotNull(String variable_mesuree, MeasurementType categorie_de_mesure) {
        return create(RefMesure.PROPERTY_VARIABLE_MESUREE, variable_mesuree, RefMesure.PROPERTY_CATEGORIE_DE_MESURE, categorie_de_mesure);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVariable_mesureeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMesure.PROPERTY_VARIABLE_MESUREE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVariable_mesureeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMesure.PROPERTY_VARIABLE_MESUREE, v);
        return result;
    }

    @Deprecated
    public E findByVariable_mesuree(String v) {
        return forVariable_mesureeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByVariable_mesuree(String v) {
        return forVariable_mesureeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUniteIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMesure.PROPERTY_UNITE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUniteEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMesure.PROPERTY_UNITE, v);
        return result;
    }

    @Deprecated
    public E findByUnite(String v) {
        return forUniteEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUnite(String v) {
        return forUniteEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValeur_attendueIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMesure.PROPERTY_VALEUR_ATTENDUE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValeur_attendueEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMesure.PROPERTY_VALEUR_ATTENDUE, v);
        return result;
    }

    @Deprecated
    public E findByValeur_attendue(String v) {
        return forValeur_attendueEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValeur_attendue(String v) {
        return forValeur_attendueEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRemarqueIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMesure.PROPERTY_REMARQUE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRemarqueEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMesure.PROPERTY_REMARQUE, v);
        return result;
    }

    @Deprecated
    public E findByRemarque(String v) {
        return forRemarqueEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRemarque(String v) {
        return forRemarqueEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMesure.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMesure.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCategorie_de_mesureIn(Collection<MeasurementType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMesure.PROPERTY_CATEGORIE_DE_MESURE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCategorie_de_mesureEquals(MeasurementType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMesure.PROPERTY_CATEGORIE_DE_MESURE, v);
        return result;
    }

    @Deprecated
    public E findByCategorie_de_mesure(MeasurementType v) {
        return forCategorie_de_mesureEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCategorie_de_mesure(MeasurementType v) {
        return forCategorie_de_mesureEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forType_variable_mesureeIn(Collection<VariableType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forType_variable_mesureeEquals(VariableType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, v);
        return result;
    }

    @Deprecated
    public E findByType_variable_mesuree(VariableType v) {
        return forType_variable_mesureeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType_variable_mesuree(VariableType v) {
        return forType_variable_mesureeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Measure.class) {
            MeasureTopiaDao dao =
                topiaDaoSupplier.getDao(Measure.class, MeasureTopiaDao.class);
            tmp = dao.forRefMesureEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Measure.class, entity);
        if (!list.isEmpty()) {
            result.put(Measure.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefMesureTopiaDao<E extends RefMesure>
