package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.EquipmentTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefMaterielTopiaDao<E extends RefMateriel> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefMateriel.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefMateriel;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            EquipmentTopiaDao dao = topiaDaoSupplier
                    .getDao(Equipment.class, EquipmentTopiaDao.class);
            List<Equipment> list = dao
                    .forProperties(Equipment.PROPERTY_REF_MATERIEL, entity)
                    .findAll();
            for (Equipment item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getRefMateriel())) {
                    item.setRefMateriel(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String typeMateriel1, String typeMateriel2, String typeMateriel3, String typeMateriel4, double uniteParAn) {
        return forNaturalId(typeMateriel1, typeMateriel2, typeMateriel3, typeMateriel4, uniteParAn).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String typeMateriel1, String typeMateriel2, String typeMateriel3, String typeMateriel4, double uniteParAn) {
        return forNaturalId(typeMateriel1, typeMateriel2, typeMateriel3, typeMateriel4, uniteParAn).exists();
    }

    public E createByNaturalId(String typeMateriel1, String typeMateriel2, String typeMateriel3, String typeMateriel4, double uniteParAn) {
        return create(RefMateriel.PROPERTY_TYPE_MATERIEL1, typeMateriel1, RefMateriel.PROPERTY_TYPE_MATERIEL2, typeMateriel2, RefMateriel.PROPERTY_TYPE_MATERIEL3, typeMateriel3, RefMateriel.PROPERTY_TYPE_MATERIEL4, typeMateriel4, RefMateriel.PROPERTY_UNITE_PAR_AN, uniteParAn);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String typeMateriel1, String typeMateriel2, String typeMateriel3, String typeMateriel4, double uniteParAn) {
        return forProperties(RefMateriel.PROPERTY_TYPE_MATERIEL1, typeMateriel1, RefMateriel.PROPERTY_TYPE_MATERIEL2, typeMateriel2, RefMateriel.PROPERTY_TYPE_MATERIEL3, typeMateriel3, RefMateriel.PROPERTY_TYPE_MATERIEL4, typeMateriel4, RefMateriel.PROPERTY_UNITE_PAR_AN, uniteParAn);
    }

    public E createByNotNull(String typeMateriel1, String typeMateriel2, String typeMateriel3, String typeMateriel4, double uniteParAn) {
        return create(RefMateriel.PROPERTY_TYPE_MATERIEL1, typeMateriel1, RefMateriel.PROPERTY_TYPE_MATERIEL2, typeMateriel2, RefMateriel.PROPERTY_TYPE_MATERIEL3, typeMateriel3, RefMateriel.PROPERTY_TYPE_MATERIEL4, typeMateriel4, RefMateriel.PROPERTY_UNITE_PAR_AN, uniteParAn);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeMateriel1In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMateriel.PROPERTY_TYPE_MATERIEL1, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeMateriel1Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMateriel.PROPERTY_TYPE_MATERIEL1, v);
        return result;
    }

    @Deprecated
    public E findByTypeMateriel1(String v) {
        return forTypeMateriel1Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTypeMateriel1(String v) {
        return forTypeMateriel1Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeMateriel2In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMateriel.PROPERTY_TYPE_MATERIEL2, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeMateriel2Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMateriel.PROPERTY_TYPE_MATERIEL2, v);
        return result;
    }

    @Deprecated
    public E findByTypeMateriel2(String v) {
        return forTypeMateriel2Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTypeMateriel2(String v) {
        return forTypeMateriel2Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeMateriel3In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMateriel.PROPERTY_TYPE_MATERIEL3, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeMateriel3Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMateriel.PROPERTY_TYPE_MATERIEL3, v);
        return result;
    }

    @Deprecated
    public E findByTypeMateriel3(String v) {
        return forTypeMateriel3Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTypeMateriel3(String v) {
        return forTypeMateriel3Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeMateriel4In(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMateriel.PROPERTY_TYPE_MATERIEL4, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeMateriel4Equals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMateriel.PROPERTY_TYPE_MATERIEL4, v);
        return result;
    }

    @Deprecated
    public E findByTypeMateriel4(String v) {
        return forTypeMateriel4Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTypeMateriel4(String v) {
        return forTypeMateriel4Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUniteIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMateriel.PROPERTY_UNITE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUniteEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMateriel.PROPERTY_UNITE, v);
        return result;
    }

    @Deprecated
    public E findByUnite(String v) {
        return forUniteEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUnite(String v) {
        return forUniteEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUniteParAnIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMateriel.PROPERTY_UNITE_PAR_AN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUniteParAnEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMateriel.PROPERTY_UNITE_PAR_AN, v);
        return result;
    }

    @Deprecated
    public E findByUniteParAn(double v) {
        return forUniteParAnEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUniteParAn(double v) {
        return forUniteParAnEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefMateriel.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefMateriel.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Equipment.class) {
            EquipmentTopiaDao dao =
                topiaDaoSupplier.getDao(Equipment.class, EquipmentTopiaDao.class);
            tmp = dao.forRefMaterielEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Equipment.class, entity);
        if (!list.isEmpty()) {
            result.put(Equipment.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefMaterielTopiaDao<E extends RefMateriel>
