package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.BasicPlot;
import fr.inra.agrosyst.api.entities.BasicPlotTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefLocationTopiaDao<E extends RefLocation> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefLocation.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefLocation;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            DomainTopiaDao dao = topiaDaoSupplier
                    .getDao(Domain.class, DomainTopiaDao.class);
            List<Domain> list = dao
                    .forProperties(Domain.PROPERTY_LOCATION, entity)
                    .findAll();
            for (Domain item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getLocation())) {
                    item.setLocation(null);
                }
            
            }
        }

        {
            BasicPlotTopiaDao dao = topiaDaoSupplier
                    .getDao(BasicPlot.class, BasicPlotTopiaDao.class);
            List<BasicPlot> list = dao
                    .forProperties(BasicPlot.PROPERTY_LOCATION, entity)
                    .findAll();
            for (BasicPlot item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getLocation())) {
                    item.setLocation(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String codeInsee) {
        return forNaturalId(codeInsee).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String codeInsee) {
        return forNaturalId(codeInsee).exists();
    }

    public E createByNaturalId(String codeInsee) {
        return create(RefLocation.PROPERTY_CODE_INSEE, codeInsee);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String codeInsee) {
        return forProperties(RefLocation.PROPERTY_CODE_INSEE, codeInsee);
    }

    public E createByNotNull(String codeInsee, String commune, String departement) {
        return create(RefLocation.PROPERTY_CODE_INSEE, codeInsee, RefLocation.PROPERTY_COMMUNE, commune, RefLocation.PROPERTY_DEPARTEMENT, departement);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeInseeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_CODE_INSEE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeInseeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_CODE_INSEE, v);
        return result;
    }

    @Deprecated
    public E findByCodeInsee(String v) {
        return forCodeInseeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCodeInsee(String v) {
        return forCodeInseeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommuneIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_COMMUNE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommuneEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_COMMUNE, v);
        return result;
    }

    @Deprecated
    public E findByCommune(String v) {
        return forCommuneEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCommune(String v) {
        return forCommuneEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPetiteRegionAgricoleCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_PETITE_REGION_AGRICOLE_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPetiteRegionAgricoleCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_PETITE_REGION_AGRICOLE_CODE, v);
        return result;
    }

    @Deprecated
    public E findByPetiteRegionAgricoleCode(String v) {
        return forPetiteRegionAgricoleCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPetiteRegionAgricoleCode(String v) {
        return forPetiteRegionAgricoleCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPetiteRegionAgricoleNomIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_PETITE_REGION_AGRICOLE_NOM, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPetiteRegionAgricoleNomEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_PETITE_REGION_AGRICOLE_NOM, v);
        return result;
    }

    @Deprecated
    public E findByPetiteRegionAgricoleNom(String v) {
        return forPetiteRegionAgricoleNomEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPetiteRegionAgricoleNom(String v) {
        return forPetiteRegionAgricoleNomEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDepartementIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_DEPARTEMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDepartementEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_DEPARTEMENT, v);
        return result;
    }

    @Deprecated
    public E findByDepartement(String v) {
        return forDepartementEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDepartement(String v) {
        return forDepartementEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodePostalIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_CODE_POSTAL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodePostalEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_CODE_POSTAL, v);
        return result;
    }

    @Deprecated
    public E findByCodePostal(String v) {
        return forCodePostalEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCodePostal(String v) {
        return forCodePostalEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRegionIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_REGION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRegionEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_REGION, v);
        return result;
    }

    @Deprecated
    public E findByRegion(int v) {
        return forRegionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRegion(int v) {
        return forRegionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLatitudeIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_LATITUDE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLatitudeEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_LATITUDE, v);
        return result;
    }

    @Deprecated
    public E findByLatitude(double v) {
        return forLatitudeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLatitude(double v) {
        return forLatitudeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLongitudeIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLocation.PROPERTY_LONGITUDE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLongitudeEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLocation.PROPERTY_LONGITUDE, v);
        return result;
    }

    @Deprecated
    public E findByLongitude(double v) {
        return forLongitudeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLongitude(double v) {
        return forLongitudeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Domain.class) {
            DomainTopiaDao dao =
                topiaDaoSupplier.getDao(Domain.class, DomainTopiaDao.class);
            tmp = dao.forLocationEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == BasicPlot.class) {
            BasicPlotTopiaDao dao =
                topiaDaoSupplier.getDao(BasicPlot.class, BasicPlotTopiaDao.class);
            tmp = dao.forLocationEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Domain.class, entity);
        if (!list.isEmpty()) {
            result.put(Domain.class, list);
        }

        list = findUsages(BasicPlot.class, entity);
        if (!list.isEmpty()) {
            result.put(BasicPlot.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefLocationTopiaDao<E extends RefLocation>
