package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefLegalStatusTopiaDao<E extends RefLegalStatus> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefLegalStatus.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefLegalStatus;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            DomainTopiaDao dao = topiaDaoSupplier
                    .getDao(Domain.class, DomainTopiaDao.class);
            List<Domain> list = dao
                    .forProperties(Domain.PROPERTY_LEGAL_STATUS, entity)
                    .findAll();
            for (Domain item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getLegalStatus())) {
                    item.setLegalStatus(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(Integer code_INSEE) {
        return forNaturalId(code_INSEE).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(Integer code_INSEE) {
        return forNaturalId(code_INSEE).exists();
    }

    public E createByNaturalId(Integer code_INSEE) {
        return create(RefLegalStatus.PROPERTY_CODE__INSEE, code_INSEE);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(Integer code_INSEE) {
        return forProperties(RefLegalStatus.PROPERTY_CODE__INSEE, code_INSEE);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCode_INSEEIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLegalStatus.PROPERTY_CODE__INSEE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCode_INSEEEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLegalStatus.PROPERTY_CODE__INSEE, v);
        return result;
    }

    @Deprecated
    public E findByCode_INSEE(Integer v) {
        return forCode_INSEEEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode_INSEE(Integer v) {
        return forCode_INSEEEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLibelle_INSEEIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLegalStatus.PROPERTY_LIBELLE__INSEE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLibelle_INSEEEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLegalStatus.PROPERTY_LIBELLE__INSEE, v);
        return result;
    }

    @Deprecated
    public E findByLibelle_INSEE(String v) {
        return forLibelle_INSEEEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLibelle_INSEE(String v) {
        return forLibelle_INSEEEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSocieteIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLegalStatus.PROPERTY_SOCIETE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSocieteEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLegalStatus.PROPERTY_SOCIETE, v);
        return result;
    }

    @Deprecated
    public E findBySociete(boolean v) {
        return forSocieteEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySociete(boolean v) {
        return forSocieteEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLegalStatus.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLegalStatus.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefLegalStatus.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefLegalStatus.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Domain.class) {
            DomainTopiaDao dao =
                topiaDaoSupplier.getDao(Domain.class, DomainTopiaDao.class);
            tmp = dao.forLegalStatusEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Domain.class, entity);
        if (!list.isEmpty()) {
            result.put(Domain.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefLegalStatusTopiaDao<E extends RefLegalStatus>
