package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefInterventionAgrosystTravailEDITopiaDao<E extends RefInterventionAgrosystTravailEDI> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefInterventionAgrosystTravailEDI.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefInterventionAgrosystTravailEDI;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            AbstractActionTopiaDao dao = topiaDaoSupplier
                    .getDao(AbstractAction.class, AbstractActionTopiaDao.class);
            List<AbstractAction> list = dao
                    .forProperties(AbstractAction.PROPERTY_MAIN_ACTION, entity)
                    .findAll();
            for (AbstractAction item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getMainAction())) {
                    item.setMainAction(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String reference_code) {
        return forNaturalId(reference_code).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String reference_code) {
        return forNaturalId(reference_code).exists();
    }

    public E createByNaturalId(String reference_code) {
        return create(RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_CODE, reference_code);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String reference_code) {
        return forProperties(RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_CODE, reference_code);
    }

    public E createByNotNull(String reference_code) {
        return create(RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_CODE, reference_code);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReference_codeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReference_codeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_CODE, v);
        return result;
    }

    @Deprecated
    public E findByReference_code(String v) {
        return forReference_codeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReference_code(String v) {
        return forReference_codeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReference_labelIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_LABEL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReference_labelEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_LABEL, v);
        return result;
    }

    @Deprecated
    public E findByReference_label(String v) {
        return forReference_labelEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReference_label(String v) {
        return forReference_labelEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefInterventionAgrosystTravailEDI.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefInterventionAgrosystTravailEDI.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefInterventionAgrosystTravailEDI.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefInterventionAgrosystTravailEDI.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntervention_agrosystIn(Collection<AgrosystInterventionType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefInterventionAgrosystTravailEDI.PROPERTY_INTERVENTION_AGROSYST, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntervention_agrosystEquals(AgrosystInterventionType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefInterventionAgrosystTravailEDI.PROPERTY_INTERVENTION_AGROSYST, v);
        return result;
    }

    @Deprecated
    public E findByIntervention_agrosyst(AgrosystInterventionType v) {
        return forIntervention_agrosystEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByIntervention_agrosyst(AgrosystInterventionType v) {
        return forIntervention_agrosystEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == AbstractAction.class) {
            AbstractActionTopiaDao dao =
                topiaDaoSupplier.getDao(AbstractAction.class, AbstractActionTopiaDao.class);
            tmp = dao.forMainActionEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == ToolsCoupling.class) {
            ToolsCouplingTopiaDao dao =
                topiaDaoSupplier.getDao(ToolsCoupling.class, ToolsCouplingTopiaDao.class);
            tmp = dao.forMainsActionsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(AbstractAction.class, entity);
        if (!list.isEmpty()) {
            result.put(AbstractAction.class, list);
        }

        list = findUsages(ToolsCoupling.class, entity);
        if (!list.isEmpty()) {
            result.put(ToolsCoupling.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefInterventionAgrosystTravailEDITopiaDao<E extends RefInterventionAgrosystTravailEDI>
