package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInputTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRuleTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.Section;
import fr.inra.agrosyst.api.entities.managementmode.SectionTopiaDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedRefBioAgressorTopiaDao<E extends RefBioAgressor> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefBioAgressor.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefBioAgressor;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            DecisionRuleTopiaDao dao = topiaDaoSupplier
                    .getDao(DecisionRule.class, DecisionRuleTopiaDao.class);
            List<DecisionRule> list = dao
                    .forProperties(DecisionRule.PROPERTY_BIO_AGRESSOR, entity)
                    .findAll();
            for (DecisionRule item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getBioAgressor())) {
                    item.setBioAgressor(null);
                }
            
            }
        }

        {
            SectionTopiaDao dao = topiaDaoSupplier
                    .getDao(Section.class, SectionTopiaDao.class);
            List<Section> list = dao
                    .forProperties(Section.PROPERTY_BIO_AGRESSOR, entity)
                    .findAll();
            for (Section item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getBioAgressor())) {
                    item.setBioAgressor(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM phytoProductInput main, phytoproductinput_targets secondary " +
                    " WHERE main.topiaId=secondary.phytoProductInput " +
                    " AND secondary.targets='" + entity.getTopiaId() + "'";
            List<PhytoProductInput> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.PhytoProductInput.getImplementation())
                    .list();

            for (PhytoProductInput item : list) {
                item.removeTargets(entity);
            }
        }

        super.delete(entity);
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == DecisionRule.class) {
            DecisionRuleTopiaDao dao =
                topiaDaoSupplier.getDao(DecisionRule.class, DecisionRuleTopiaDao.class);
            tmp = dao.forBioAgressorEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Section.class) {
            SectionTopiaDao dao =
                topiaDaoSupplier.getDao(Section.class, SectionTopiaDao.class);
            tmp = dao.forBioAgressorEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == PhytoProductInput.class) {
            PhytoProductInputTopiaDao dao =
                topiaDaoSupplier.getDao(PhytoProductInput.class, PhytoProductInputTopiaDao.class);
            tmp = dao.forTargetsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(DecisionRule.class, entity);
        if (!list.isEmpty()) {
            result.put(DecisionRule.class, list);
        }

        list = findUsages(Section.class, entity);
        if (!list.isEmpty()) {
            result.put(Section.class, list);
        }

        list = findUsages(PhytoProductInput.class, entity);
        if (!list.isEmpty()) {
            result.put(PhytoProductInput.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefBioAgressorTopiaDao<E extends RefBioAgressor>
