package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.measure.Observation;
import fr.inra.agrosyst.api.entities.measure.ObservationTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedRefAdventiceTopiaDao<E extends RefAdventice> extends AbstractRefBioAgressorTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefAdventice.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefAdventice;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            ObservationTopiaDao dao = topiaDaoSupplier
                    .getDao(Observation.class, ObservationTopiaDao.class);
            List<Observation> list = dao
                    .forProperties(Observation.PROPERTY_MEASURED_ADVENTICE, entity)
                    .findAll();
            for (Observation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getMeasuredAdventice())) {
                    item.setMeasuredAdventice(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String identifiant) {
        return forNaturalId(identifiant).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String identifiant) {
        return forNaturalId(identifiant).exists();
    }

    public E createByNaturalId(String identifiant) {
        return create(RefAdventice.PROPERTY_IDENTIFIANT, identifiant);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String identifiant) {
        return forProperties(RefAdventice.PROPERTY_IDENTIFIANT, identifiant);
    }

    public E createByNotNull(String identifiant) {
        return create(RefAdventice.PROPERTY_IDENTIFIANT, identifiant);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAdventiceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefAdventice.PROPERTY_ADVENTICE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAdventiceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefAdventice.PROPERTY_ADVENTICE, v);
        return result;
    }

    @Deprecated
    public E findByAdventice(String v) {
        return forAdventiceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAdventice(String v) {
        return forAdventiceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIdentifiantIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefAdventice.PROPERTY_IDENTIFIANT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIdentifiantEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefAdventice.PROPERTY_IDENTIFIANT, v);
        return result;
    }

    @Deprecated
    public E findByIdentifiant(String v) {
        return forIdentifiantEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByIdentifiant(String v) {
        return forIdentifiantEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFamille_de_cultureIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefAdventice.PROPERTY_FAMILLE_DE_CULTURE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFamille_de_cultureEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefAdventice.PROPERTY_FAMILLE_DE_CULTURE, v);
        return result;
    }

    @Deprecated
    public E findByFamille_de_culture(String v) {
        return forFamille_de_cultureEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFamille_de_culture(String v) {
        return forFamille_de_cultureEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefAdventice.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefAdventice.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefAdventice.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefAdventice.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Observation.class) {
            ObservationTopiaDao dao =
                topiaDaoSupplier.getDao(Observation.class, ObservationTopiaDao.class);
            tmp = dao.forMeasuredAdventiceEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Observation.class, entity);
        if (!list.isEmpty()) {
            result.put(Observation.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefAdventiceTopiaDao<E extends RefAdventice>
