package fr.inra.agrosyst.api.entities.referential;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.measure.Measure;
import fr.inra.agrosyst.api.entities.measure.MeasureTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedRefActaSubstanceActiveTopiaDao<E extends RefActaSubstanceActive> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RefActaSubstanceActive.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.RefActaSubstanceActive;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            MeasureTopiaDao dao = topiaDaoSupplier
                    .getDao(Measure.class, MeasureTopiaDao.class);
            List<Measure> list = dao
                    .forProperties(Measure.PROPERTY_ACTIVE_SUBSTANCE, entity)
                    .findAll();
            for (Measure item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getActiveSubstance())) {
                    item.setActiveSubstance(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String id_produit, String nom_commun_sa) {
        return forNaturalId(id_produit, nom_commun_sa).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String id_produit, String nom_commun_sa) {
        return forNaturalId(id_produit, nom_commun_sa).exists();
    }

    public E createByNaturalId(String id_produit, String nom_commun_sa) {
        return create(RefActaSubstanceActive.PROPERTY_ID_PRODUIT, id_produit, RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA, nom_commun_sa);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String id_produit, String nom_commun_sa) {
        return forProperties(RefActaSubstanceActive.PROPERTY_ID_PRODUIT, id_produit, RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA, nom_commun_sa);
    }

    public E createByNotNull(String id_produit, String nom_commun_sa) {
        return create(RefActaSubstanceActive.PROPERTY_ID_PRODUIT, id_produit, RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA, nom_commun_sa);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forId_produitIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefActaSubstanceActive.PROPERTY_ID_PRODUIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forId_produitEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefActaSubstanceActive.PROPERTY_ID_PRODUIT, v);
        return result;
    }

    @Deprecated
    public E findById_produit(String v) {
        return forId_produitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllById_produit(String v) {
        return forId_produitEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNom_produitIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefActaSubstanceActive.PROPERTY_NOM_PRODUIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNom_produitEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefActaSubstanceActive.PROPERTY_NOM_PRODUIT, v);
        return result;
    }

    @Deprecated
    public E findByNom_produit(String v) {
        return forNom_produitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByNom_produit(String v) {
        return forNom_produitEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNom_commun_saIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNom_commun_saEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefActaSubstanceActive.PROPERTY_NOM_COMMUN_SA, v);
        return result;
    }

    @Deprecated
    public E findByNom_commun_sa(String v) {
        return forNom_commun_saEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByNom_commun_sa(String v) {
        return forNom_commun_saEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConcentration_valeurIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefActaSubstanceActive.PROPERTY_CONCENTRATION_VALEUR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConcentration_valeurEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefActaSubstanceActive.PROPERTY_CONCENTRATION_VALEUR, v);
        return result;
    }

    @Deprecated
    public E findByConcentration_valeur(double v) {
        return forConcentration_valeurEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByConcentration_valeur(double v) {
        return forConcentration_valeurEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConcentration_uniteIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefActaSubstanceActive.PROPERTY_CONCENTRATION_UNITE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConcentration_uniteEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefActaSubstanceActive.PROPERTY_CONCENTRATION_UNITE, v);
        return result;
    }

    @Deprecated
    public E findByConcentration_unite(String v) {
        return forConcentration_uniteEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByConcentration_unite(String v) {
        return forConcentration_uniteEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefActaSubstanceActive.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefActaSubstanceActive.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRemarquesIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefActaSubstanceActive.PROPERTY_REMARQUES, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRemarquesEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefActaSubstanceActive.PROPERTY_REMARQUES, v);
        return result;
    }

    @Deprecated
    public E findByRemarques(String v) {
        return forRemarquesEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRemarques(String v) {
        return forRemarquesEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RefActaSubstanceActive.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RefActaSubstanceActive.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Measure.class) {
            MeasureTopiaDao dao =
                topiaDaoSupplier.getDao(Measure.class, MeasureTopiaDao.class);
            tmp = dao.forActiveSubstanceEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Measure.class, entity);
        if (!list.isEmpty()) {
            result.put(Measure.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRefActaSubstanceActiveTopiaDao<E extends RefActaSubstanceActive>
