package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: AbstractRefMaterielTopiaDao.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/AbstractRefMaterielTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class AbstractRefMaterielTopiaDao<E extends RefMateriel> extends GeneratedRefMaterielTopiaDao<E> {

    /**
     * Recherche dans la liste des RefMaterielAutomoteur les valeurs de materielType1 
     * 
     * @return materielType1 value
     * @throws TopiaException 
     */
    public List<String> findTypeMateriel1Values() throws TopiaException {
        List<String> result = findPropertyValues(RefMateriel.PROPERTY_TYPE_MATERIEL1, null, null, null);
        return result;
    }

    /**
     * Recherche dans la liste des RefMateriel les valeurs de materielType[2-4] suivant les filtres
     * typeMateriel[1-3]
     * 
     * @param property property to extract
     * @param typeMateriel1 optionnal type 1 filter
     * @param typeMateriel2 optionnal type 2 filter
     * @param typeMateriel3 optionnal type 3 filter
     * @return
     * @throws TopiaException 
     */
    public List<String> findPropertyValues(String property, String typeMateriel1, String typeMateriel2,
            String typeMateriel3) throws TopiaException {
        String query = "SELECT distinct( m." + property + " ) " +
                " FROM " + getEntityClass().getName() + " m " +
                " WHERE m." + RefMateriel.PROPERTY_ACTIVE + " = true";

        Map<String, Object> args = Maps.newHashMap();
        query += DaoUtils.andAttributeEquals("m", RefMateriel.PROPERTY_TYPE_MATERIEL1, args, typeMateriel1);

        query += DaoUtils.andAttributeEquals("m", RefMateriel.PROPERTY_TYPE_MATERIEL2, args, typeMateriel2);

        query += DaoUtils.andAttributeEquals("m", RefMateriel.PROPERTY_TYPE_MATERIEL3, args, typeMateriel3);

        query += " ORDER BY m." + property + " ASC ";

        List<String> result = findAll(query, args);
        return result;
    }
    
    /**
     * Recherche dans la liste des RefMateriel les valeurs de deux colonnes suivant les filtres
     * typeMateriel[1-4]
     * 
     * @param property property key to extract
     * @param property2 property value to extract
     * @param typeMateriel1 optionnal type 1 filter
     * @param typeMateriel2 optionnal type 2 filter
     * @param typeMateriel3 optionnal type 3 filter
     * @param typeMateriel4 optionnal type 4 filter
     * @return
     * @throws TopiaException 
     */
    public Map<String, String[]> findPropertyValuesAsMap(String property, String property2, String typeMateriel1,
            String typeMateriel2, String typeMateriel3, String typeMateriel4) throws TopiaException {
        String query = "SELECT m." + TopiaEntity.PROPERTY_TOPIA_ID + ", m." + property + ", m." + property2 +
                " FROM " + getEntityClass().getName() + " m " +
                " WHERE m." + RefMateriel.PROPERTY_ACTIVE + " = true";

        Map<String, Object> args = Maps.newHashMap();
        query += DaoUtils.andAttributeEquals("m", RefMateriel.PROPERTY_TYPE_MATERIEL1, args, typeMateriel1);

        query += DaoUtils.andAttributeEquals("m", RefMateriel.PROPERTY_TYPE_MATERIEL2, args, typeMateriel2);

        query += DaoUtils.andAttributeEquals("m", RefMateriel.PROPERTY_TYPE_MATERIEL3, args, typeMateriel3);

        query += DaoUtils.andAttributeEquals("m", RefMateriel.PROPERTY_TYPE_MATERIEL4, args, typeMateriel4);

        query += " ORDER BY m." + property + " ASC ";

        List<Object[]> rows = findAll(query, args);
        Map<String, String[]> result = Maps.newLinkedHashMap();
        for (Object[] row : rows) {
            String topiaId = (String) row[0];
            String[] properties1And2Values = {String.valueOf(row[1]), (String) row[2]};
            result.put(topiaId, properties1And2Values);
        }
        return result;
    }
} //AbstractRefMaterielTopiaDao<E extends RefMateriel>
