package fr.inra.agrosyst.api.entities.practiced;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PracticedPlotTopiaDao.java 4653 2014-12-15 14:00:17Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/practiced/PracticedPlotTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.nuiton.util.PagerBean;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityContext;
import fr.inra.agrosyst.services.security.SecurityHelper;

public class PracticedPlotTopiaDao extends AbstractPracticedPlotTopiaDao<PracticedPlot> {

    protected static final String PROPERTY_PRACTICED_SYSTEM_NAME = PracticedPlot.PROPERTY_PRACTICED_SYSTEM + "." + PracticedSystem.PROPERTY_NAME;
    protected static final String PROPERTY_PRACTICED_SYSTEM_CAMPAIGNS = PracticedPlot.PROPERTY_PRACTICED_SYSTEM + "." + PracticedSystem.PROPERTY_CAMPAIGNS;

    protected static final String PROPERTY_GROWING_SYSTEM = PracticedPlot.PROPERTY_PRACTICED_SYSTEM + "." + PracticedSystem.PROPERTY_GROWING_SYSTEM;
    protected static final String PROPERTY_GROWING_SYSTEM_ID = PROPERTY_GROWING_SYSTEM + "." + GrowingSystem.PROPERTY_TOPIA_ID;
    protected static final String PROPERTY_GROWING_SYSTEM_NAME = PROPERTY_GROWING_SYSTEM + "." + GrowingSystem.PROPERTY_NAME;

    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN = PROPERTY_GROWING_SYSTEM + "." + GrowingSystem.PROPERTY_GROWING_PLAN;
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_ID = PROPERTY_GROWING_SYSTEM_GROWING_PLAN + "." + GrowingPlan.PROPERTY_TOPIA_ID;
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_NAME = PROPERTY_GROWING_SYSTEM_GROWING_PLAN + "." + GrowingPlan.PROPERTY_NAME;

    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN = PROPERTY_GROWING_SYSTEM_GROWING_PLAN + "." + GrowingPlan.PROPERTY_DOMAIN;
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_ID = PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN + "." + Domain.PROPERTY_TOPIA_ID;
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_NAME = PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN + "." + Domain.PROPERTY_NAME;
    protected static final String PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_CAMPAIGN = PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN + "." + Domain.PROPERTY_CAMPAIGN;

    public ResultList<PracticedPlot> getFilteredPracticedPlots(PracticedPlotFilter filter, SecurityContext securityContext) {
        StringBuilder query = new StringBuilder(" FROM " + getEntityClass().getName() + " pp ");
        query.append(" WHERE 1 = 1 ");
        Map<String, Object> args = Maps.newLinkedHashMap();

        // apply non null filter
        if (filter != null) {

            // PracticedPlot name
            query.append(DaoUtils.andAttributeLike("pp", PracticedPlot.PROPERTY_NAME, args, filter.getPracticedPlotName()));

            // PracticedSystem name
            query.append(DaoUtils.andAttributeLike("pp", PROPERTY_PRACTICED_SYSTEM_NAME, args, filter.getPracticedSystemName()));

            // Growing System
            query.append(DaoUtils.andAttributeLike("pp", PROPERTY_GROWING_SYSTEM_NAME, args, filter.getGrowingSystemName()));

            // PracticedSystem campaigns
            query.append(DaoUtils.andAttributeLike("pp", PracticedSystem.PROPERTY_CAMPAIGNS, args, filter.getPracticedSystemCampaign()));
            
            // Domain name
            query.append(DaoUtils.andAttributeLike("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_NAME, args, filter.getDomainName()));
            
            // GrowingPlan name
            query.append(DaoUtils.andAttributeLike("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_NAME, args, filter.getGrowingPlanName()));

            // Navigation context
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {

                // campaigns
                // FIXME query must compare PracticedSystem campaing and not domain campaigns
                query.append(DaoUtils.andAttributeInIfNotEmpty("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns()));

                // networks
                if (navigationContext.getNetworksCount() > 0) {
                    Set<String> growingSystemIds = getProjectionHelper().networksToGrowingSystems(navigationContext.getNetworks());
                    query.append(DaoUtils.andAttributeIn("pp", PROPERTY_GROWING_SYSTEM_ID, args, growingSystemIds));
                }

                // domains
                query.append(DaoUtils.andAttributeInIfNotEmpty("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_DOMAIN_ID, args, navigationContext.getDomains()));

                // growingPlans
                query.append(DaoUtils.andAttributeInIfNotEmpty("pp", PROPERTY_GROWING_SYSTEM_GROWING_PLAN_ID, args, navigationContext.getGrowingPlans()));

                // growingSystems
                // FIXME query must compare code and not id
                query.append(DaoUtils.andAttributeInIfNotEmpty("pp", PROPERTY_GROWING_SYSTEM_ID, args, navigationContext.getGrowingSystems()));
            }
        }

        SecurityHelper.addPracticedPlotFilter(query, args, securityContext, "pp");

        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;

        List<PracticedPlot> practicedPlots = find(query + " ORDER BY lower (pp." + PracticedPlot.PROPERTY_NAME +")", args, startIndex, endIndex);
        long totalCount = findUnique("SELECT count(*) " + query, args);

        // build result bean
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);

        ResultList<PracticedPlot> result = ResultList.of(practicedPlots, pager);

        return result;
    }

    public PracticedPlot getPlotForPracticedCropCyclePhase(PracticedCropCyclePhase phase) {
        String query = "FROM " + getEntityClass().getName() + " pp" +
                " WHERE pp." + PracticedPlot.PROPERTY_PRACTICED_SYSTEM + " in (" +
                " SELECT ppcc." + PracticedPerennialCropCycle.PROPERTY_PRACTICED_SYSTEM + " FROM " + PracticedPerennialCropCycle.class.getName() + " ppcc" +
                "  WHERE :phase in elements(ppcc." + PracticedPerennialCropCycle.PROPERTY_CROP_CYCLE_PHASES + "))";
        
        PracticedPlot result = findUniqueOrNull(query, DaoUtils.asArgsMap("phase", phase));
        return result;
    }

} //PracticedPlotTopiaDao
