package fr.inra.agrosyst.api.entities.practiced;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PracticedPerennialCropCycleTopiaDao.java 3691 2014-03-10 17:02:53Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/practiced/PracticedPerennialCropCycleTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.utils.DaoUtils;

public class PracticedPerennialCropCycleTopiaDao extends AbstractPracticedPerennialCropCycleTopiaDao<PracticedPerennialCropCycle> {

    public PracticedPerennialCropCycle findPerennialCropCycleForIntervention(PracticedIntervention practicedIntervention) {
        String query = "FROM " + PracticedPerennialCropCycle.class.getName() + " C" +
                " WHERE :practicedCropCyclePhase in elements (C." + PracticedPerennialCropCycle.PROPERTY_CROP_CYCLE_PHASES + ")";

        return findUnique(query, DaoUtils.asArgsMap("practicedCropCyclePhase", practicedIntervention.getPracticedCropCyclePhase()));
    }
} //PracticedPerennialCropCycleTopiaDao
