package fr.inra.agrosyst.api.entities.practiced;

import java.util.Map;

import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.utils.DaoUtils;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PracticedInterventionTopiaDao.java 3691 2014-03-10 17:02:53Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/practiced/PracticedInterventionTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

public class PracticedInterventionTopiaDao extends AbstractPracticedInterventionTopiaDao<PracticedIntervention> {

    /**
     * Recherche parmis toutes les interventions d'une connexion ou d'un noeud, celle qui a une
     * action 'semis' définie.
     * 
     * @param practicedCropCycleConnection connection
     * @return
     */
    public PracticedIntervention findFirstInterventionWithSeedingAction(PracticedCropCycleConnection practicedCropCycleConnection) {
        String query = "FROM " + PracticedIntervention.class.getName() + " I" +
            " WHERE I." + PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION + " = :" + PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION +
            " AND EXISTS (FROM " + SeedingAction.class.getName() + " A" +
            "    WHERE A." + SeedingAction.PROPERTY_PRACTICED_INTERVENTION + " = I)"; 

        Map<String, Object> args = DaoUtils.asArgsMap(PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION, practicedCropCycleConnection);

        // FIXME echatellier 20140220: S'il y a deux actions qui ont des actions de semis, cela ne renverra peut etre pas la bonne
        PracticedIntervention result = findAnyOrNull(query, args);
        return result;
    }
    
    /**
     * Recherche parmis toutes les interventions d'une connexion ou d'un noeud, celle qui a une
     * action 'semis' définie.
     * 
     * @param practicedCropCyclePhase phase
     * @return
     */
    public PracticedIntervention findFirstInterventionWithSeedingAction(PracticedCropCyclePhase practicedCropCyclePhase) {
        String query = "FROM " + PracticedIntervention.class.getName() + " I" +
            " WHERE I." + PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_PHASE + " = :" + PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_PHASE +
            " AND EXISTS (FROM " + SeedingAction.class.getName() + " A" +
            "    WHERE A." + SeedingAction.PROPERTY_PRACTICED_INTERVENTION + " = I)"; 

        Map<String, Object> args = DaoUtils.asArgsMap(PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_PHASE, practicedCropCyclePhase);

        // FIXME echatellier 20140220: S'il y a deux actions qui ont des actions de semis, cela ne renverra peut etre pas la bonne
        PracticedIntervention result = findUniqueOrNull(query, args);
        return result;
    }
    
} //PracticedInterventionTopiaDao
