package fr.inra.agrosyst.api.entities.practiced;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PracticedCropCycleTopiaDao.java 3840 2014-03-21 10:48:23Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/practiced/PracticedCropCycleTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.nuiton.util.PagerBean;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;

public class PracticedCropCycleTopiaDao extends AbstractPracticedCropCycleTopiaDao<PracticedCropCycle> {

    protected static final String PRACTICED_SYSTEM_SDC = PracticedCropCycle.PROPERTY_PRACTICED_SYSTEM + "." + PracticedSystem.PROPERTY_GROWING_SYSTEM;
    protected static final String SDC_ID = PRACTICED_SYSTEM_SDC + "." + GrowingSystem.PROPERTY_TOPIA_ID;
    protected static final String SDC_NAME = PRACTICED_SYSTEM_SDC + "." + GrowingSystem.PROPERTY_NAME;
    protected static final String PRACTICED_SYSTEM_SDC_GROWING_PLAN = PRACTICED_SYSTEM_SDC + "." + GrowingSystem.PROPERTY_GROWING_PLAN;
    protected static final String GROWING_PLAN_ID = PRACTICED_SYSTEM_SDC_GROWING_PLAN + "." + GrowingPlan.PROPERTY_TOPIA_ID;
    protected static final String PRACTICED_SYSTEM_SDC_GROWING_PLAN_DOMAIN = PRACTICED_SYSTEM_SDC_GROWING_PLAN + "." + GrowingPlan.PROPERTY_DOMAIN;
    protected static final String DOMAIN_ID = PRACTICED_SYSTEM_SDC_GROWING_PLAN_DOMAIN + "." + Domain.PROPERTY_TOPIA_ID;
    protected static final String DOMAIN_CAMPAIGN = PRACTICED_SYSTEM_SDC_GROWING_PLAN_DOMAIN + "." + Domain.PROPERTY_CAMPAIGN;
    protected static final String PRACTICED_SYSTEM_NAME = PracticedCropCycle.PROPERTY_PRACTICED_SYSTEM + "." + PracticedSystem.PROPERTY_NAME;
    protected static final String PRACTICED_SYSTEM_CAMPAIGNS = PracticedCropCycle.PROPERTY_PRACTICED_SYSTEM + "." + PracticedSystem.PROPERTY_CAMPAIGNS;

    public ResultList<PracticedCropCycle> getFilteredCycles(PracticedCropCycleFilter filter) {

        String className = getEntityClass().getName();
        if (filter != null && !Strings.isNullOrEmpty(filter.getPracticedCropCycleType())) {
            className = filter.getPracticedCropCycleType();
        }

        String query = "FROM " + className + " pcc";
        query += " WHERE 1 = 1";
        Map<String, Object> args = Maps.newLinkedHashMap();

        // apply non null filter
        if (filter != null) {

            // PracticedSystem name
            query += DaoUtils.andAttributeLike("pcc", PRACTICED_SYSTEM_NAME, args, filter.getPracticedSystemName());

            // Growing System
            query += DaoUtils.andAttributeLike("pcc", SDC_NAME, args, filter.getGrowingSystemName());

            // PracticedSystem campaigns
            query += DaoUtils.andAttributeLike("pcc", PRACTICED_SYSTEM_CAMPAIGNS, args, filter.getPracticedSystemCampaign());

            // Navigation context
            NavigationContext navigationContext = filter.getNavigationContext();
            if (navigationContext != null) {

                // campaigns
                query += DaoUtils.andAttributeInIfNotEmpty("pcc", DOMAIN_CAMPAIGN, args, navigationContext.getCampaigns());

                // domains
                query += DaoUtils.andAttributeInIfNotEmpty("pcc", DOMAIN_ID, args, navigationContext.getDomains());

                // growingPlans
                query += DaoUtils.andAttributeInIfNotEmpty("pcc", GROWING_PLAN_ID, args, navigationContext.getGrowingPlans());

                // growingSystems
                query += DaoUtils.andAttributeInIfNotEmpty("pcc", SDC_ID, args, navigationContext.getGrowingSystems());
            }
        }

        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List<PracticedCropCycle> cycles = find(query + " ORDER BY pcc." + PracticedCropCycle.PROPERTY_TOPIA_CREATE_DATE + " DESC, pcc." + PracticedCropCycle.PROPERTY_TOPIA_ID, args, startIndex, endIndex);
        long totalCount = findUnique("SELECT count(*) " + query, args);

        // build result bean
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);

        ResultList<PracticedCropCycle> result = ResultList.of(cycles, pager);

        return result;
    }

} //PracticedCropCycleTopiaDao<E extends PracticedCropCycle>
