package fr.inra.agrosyst.api.entities.practiced;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PracticedCropCycleConnectionTopiaDao.java 5135 2015-11-24 15:36:12Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/practiced/PracticedCropCycleConnectionTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.utils.DaoUtils;

import java.util.List;
import java.util.Set;

public class PracticedCropCycleConnectionTopiaDao extends AbstractPracticedCropCycleConnectionTopiaDao<PracticedCropCycleConnection> {

    protected static final String PROPERTY_CYCLE_ID = PracticedCropCycleConnection.PROPERTY_TARGET + "." + PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE + "." + PracticedSeasonalCropCycle.PROPERTY_TOPIA_ID;

    public List<PracticedCropCycleConnection> findAllByCropCycle(String cycleId) {
        String query = "FROM " + getEntityClass().getName() + " ccnc";
        query += " WHERE " + PROPERTY_CYCLE_ID + " = :cycleId";
        List<PracticedCropCycleConnection> result = findAll(query, DaoUtils.asArgsMap("cycleId", cycleId));
        return result;
    }

    public List<PracticedCropCycleConnection> findAllByCropCycles(Set<String> cycleIds) {
        String query = "FROM " + getEntityClass().getName() + " ccnc";
        query += " WHERE " + PROPERTY_CYCLE_ID + " IN (:cycleIds)";
        List<PracticedCropCycleConnection> result = findAll(query, DaoUtils.asArgsMap("cycleIds", cycleIds));
        return result;
    }

} //PracticedCropCycleNodeConnectionDAOImpl<E extends CropCycleNodeConnection>
