package fr.inra.agrosyst.api.entities.practiced;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.PriceTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedPracticedSystemTopiaDao<E extends PracticedSystem> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) PracticedSystem.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.PracticedSystem;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PracticedCropCycleTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedCropCycle.class, PracticedCropCycleTopiaDao.class);
            List<PracticedCropCycle> list = dao
                    .forProperties(PracticedCropCycle.PROPERTY_PRACTICED_SYSTEM, entity)
                    .findAll();
            for (PracticedCropCycle item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPracticedSystem())) {
                    item.setPracticedSystem(null);
                }
            
            }
        }

        {
            PriceTopiaDao dao = topiaDaoSupplier
                    .getDao(Price.class, PriceTopiaDao.class);
            List<Price> list = dao
                    .forProperties(Price.PROPERTY_PRACTICED_SYSTEM, entity)
                    .findAll();
            for (Price item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPracticedSystem())) {
                    item.setPracticedSystem(null);
                }
            
            }
        }

        {
            PracticedPlotTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedPlot.class, PracticedPlotTopiaDao.class);
            List<PracticedPlot> list = dao
                    .forProperties(PracticedPlot.PROPERTY_PRACTICED_SYSTEM, entity)
                    .findAll();
            for (PracticedPlot item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPracticedSystem())) {
                    item.setPracticedSystem(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String name, String campaigns, Date updateDate, GrowingSystem growingSystem) {
        return create(PracticedSystem.PROPERTY_NAME, name, PracticedSystem.PROPERTY_CAMPAIGNS, campaigns, PracticedSystem.PROPERTY_UPDATE_DATE, updateDate, PracticedSystem.PROPERTY_GROWING_SYSTEM, growingSystem);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCampaignsIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_CAMPAIGNS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCampaignsEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_CAMPAIGNS, v);
        return result;
    }

    @Deprecated
    public E findByCampaigns(String v) {
        return forCampaignsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCampaigns(String v) {
        return forCampaignsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidationDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_VALIDATION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidationDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_VALIDATION_DATE, v);
        return result;
    }

    @Deprecated
    public E findByValidationDate(Date v) {
        return forValidationDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidationDate(Date v) {
        return forValidationDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUpdateDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_UPDATE_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUpdateDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_UPDATE_DATE, v);
        return result;
    }

    @Deprecated
    public E findByUpdateDate(Date v) {
        return forUpdateDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUpdateDate(Date v) {
        return forUpdateDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<PracticedSystemSource> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(PracticedSystemSource v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(PracticedSystemSource v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(PracticedSystemSource v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGrowingSystemIn(Collection<GrowingSystem> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedSystem.PROPERTY_GROWING_SYSTEM, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGrowingSystemEquals(GrowingSystem v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedSystem.PROPERTY_GROWING_SYSTEM, v);
        return result;
    }

    @Deprecated
    public E findByGrowingSystem(GrowingSystem v) {
        return forGrowingSystemEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGrowingSystem(GrowingSystem v) {
        return forGrowingSystemEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == PracticedCropCycle.class) {
            PracticedCropCycleTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedCropCycle.class, PracticedCropCycleTopiaDao.class);
            tmp = dao.forPracticedSystemEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == PracticedPlot.class) {
            PracticedPlotTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedPlot.class, PracticedPlotTopiaDao.class);
            tmp = dao.forPracticedSystemEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Price.class) {
            PriceTopiaDao dao =
                topiaDaoSupplier.getDao(Price.class, PriceTopiaDao.class);
            tmp = dao.forPracticedSystemEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(PracticedCropCycle.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedCropCycle.class, list);
        }

        list = findUsages(PracticedPlot.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedPlot.class, list);
        }

        list = findUsages(Price.class, entity);
        if (!list.isEmpty()) {
            result.put(Price.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPracticedSystemTopiaDao<E extends PracticedSystem>
