package fr.inra.agrosyst.api.entities.practiced;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.OrchardFrutalForm;
import fr.inra.agrosyst.api.entities.PollinatorSpreadMode;
import fr.inra.agrosyst.api.entities.VineFrutalForm;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedPracticedPerennialCropCycleTopiaDao<E extends PracticedPerennialCropCycle> extends AbstractPracticedCropCycleTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) PracticedPerennialCropCycle.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.PracticedPerennialCropCycle;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PracticedCropCycleSpeciesTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedCropCycleSpecies.class, PracticedCropCycleSpeciesTopiaDao.class);
            List<PracticedCropCycleSpecies> list = dao
                    .forProperties(PracticedCropCycleSpecies.PROPERTY_CYCLE, entity)
                    .findAll();
            for (PracticedCropCycleSpecies item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCycle())) {
                    item.setCycle(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String croppingPlanEntryCode, double solOccupationPercent, WeedType weedType, PracticedCropCyclePhase cropCyclePhases, PracticedSystem practicedSystem) {
        return create(PracticedPerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY_CODE, croppingPlanEntryCode, PracticedPerennialCropCycle.PROPERTY_SOL_OCCUPATION_PERCENT, solOccupationPercent, PracticedPerennialCropCycle.PROPERTY_WEED_TYPE, weedType, PracticedPerennialCropCycle.PROPERTY_CROP_CYCLE_PHASES, cropCyclePhases, PracticedPerennialCropCycle.PROPERTY_PRACTICED_SYSTEM, practicedSystem);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingYearIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_PLANTING_YEAR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingYearEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_PLANTING_YEAR, v);
        return result;
    }

    @Deprecated
    public E findByPlantingYear(Integer v) {
        return forPlantingYearEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingYear(Integer v) {
        return forPlantingYearEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDensityIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_PLANTING_DENSITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDensityEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_PLANTING_DENSITY, v);
        return result;
    }

    @Deprecated
    public E findByPlantingDensity(Double v) {
        return forPlantingDensityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingDensity(Double v) {
        return forPlantingDensityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingInterFurrowIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_PLANTING_INTER_FURROW, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingInterFurrowEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_PLANTING_INTER_FURROW, v);
        return result;
    }

    @Deprecated
    public E findByPlantingInterFurrow(Integer v) {
        return forPlantingInterFurrowEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingInterFurrow(Integer v) {
        return forPlantingInterFurrowEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingSpacingIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_PLANTING_SPACING, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingSpacingEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_PLANTING_SPACING, v);
        return result;
    }

    @Deprecated
    public E findByPlantingSpacing(Integer v) {
        return forPlantingSpacingEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingSpacing(Integer v) {
        return forPlantingSpacingEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDeathRateIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDeathRateEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE, v);
        return result;
    }

    @Deprecated
    public E findByPlantingDeathRate(Double v) {
        return forPlantingDeathRateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingDeathRate(Double v) {
        return forPlantingDeathRateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDeathRateMeasureYearIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDeathRateMeasureYearEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR, v);
        return result;
    }

    @Deprecated
    public E findByPlantingDeathRateMeasureYear(Integer v) {
        return forPlantingDeathRateMeasureYearEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingDeathRateMeasureYear(Integer v) {
        return forPlantingDeathRateMeasureYearEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanEntryCode(String v) {
        return forCroppingPlanEntryCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanEntryCode(String v) {
        return forCroppingPlanEntryCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_POLLINATOR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_POLLINATOR, v);
        return result;
    }

    @Deprecated
    public E findByPollinator(boolean v) {
        return forPollinatorEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPollinator(boolean v) {
        return forPollinatorEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorPercentIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_POLLINATOR_PERCENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorPercentEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_POLLINATOR_PERCENT, v);
        return result;
    }

    @Deprecated
    public E findByPollinatorPercent(Double v) {
        return forPollinatorPercentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPollinatorPercent(Double v) {
        return forPollinatorPercentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherCharacteristicsIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_OTHER_CHARACTERISTICS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherCharacteristicsEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_OTHER_CHARACTERISTICS, v);
        return result;
    }

    @Deprecated
    public E findByOtherCharacteristics(String v) {
        return forOtherCharacteristicsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtherCharacteristics(String v) {
        return forOtherCharacteristicsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSolOccupationPercentIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_SOL_OCCUPATION_PERCENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSolOccupationPercentEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_SOL_OCCUPATION_PERCENT, v);
        return result;
    }

    @Deprecated
    public E findBySolOccupationPercent(double v) {
        return forSolOccupationPercentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySolOccupationPercent(double v) {
        return forSolOccupationPercentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFoliageHeightIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_FOLIAGE_HEIGHT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFoliageHeightEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_FOLIAGE_HEIGHT, v);
        return result;
    }

    @Deprecated
    public E findByFoliageHeight(Double v) {
        return forFoliageHeightEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFoliageHeight(Double v) {
        return forFoliageHeightEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFoliageThicknessIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_FOLIAGE_THICKNESS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFoliageThicknessEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_FOLIAGE_THICKNESS, v);
        return result;
    }

    @Deprecated
    public E findByFoliageThickness(Double v) {
        return forFoliageThicknessEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFoliageThickness(Double v) {
        return forFoliageThicknessEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrchardFrutalFormIn(Collection<OrchardFrutalForm> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_ORCHARD_FRUTAL_FORM, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrchardFrutalFormEquals(OrchardFrutalForm v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_ORCHARD_FRUTAL_FORM, v);
        return result;
    }

    @Deprecated
    public E findByOrchardFrutalForm(OrchardFrutalForm v) {
        return forOrchardFrutalFormEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrchardFrutalForm(OrchardFrutalForm v) {
        return forOrchardFrutalFormEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrientationIn(Collection<RefOrientationEDI> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_ORIENTATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrientationEquals(RefOrientationEDI v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_ORIENTATION, v);
        return result;
    }

    @Deprecated
    public E findByOrientation(RefOrientationEDI v) {
        return forOrientationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrientation(RefOrientationEDI v) {
        return forOrientationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWeedTypeIn(Collection<WeedType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_WEED_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWeedTypeEquals(WeedType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_WEED_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByWeedType(WeedType v) {
        return forWeedTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWeedType(WeedType v) {
        return forWeedTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCropCyclePhasesContains(PracticedCropCyclePhase v) {
        return forContains(PracticedPerennialCropCycle.PROPERTY_CROP_CYCLE_PHASES, v);
    }

    @Deprecated
    public E findContainsCropCyclePhases(PracticedCropCyclePhase v) {
        return forCropCyclePhasesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsCropCyclePhases(PracticedCropCyclePhase v) {
        return forCropCyclePhasesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedCropCycleSpeciesContains(PracticedCropCycleSpecies v) {
        return forContains(PracticedPerennialCropCycle.PROPERTY_PRACTICED_CROP_CYCLE_SPECIES, v);
    }

    @Deprecated
    public E findContainsPracticedCropCycleSpecies(PracticedCropCycleSpecies v) {
        return forPracticedCropCycleSpeciesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsPracticedCropCycleSpecies(PracticedCropCycleSpecies v) {
        return forPracticedCropCycleSpeciesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVineFrutalFormIn(Collection<VineFrutalForm> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_VINE_FRUTAL_FORM, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVineFrutalFormEquals(VineFrutalForm v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_VINE_FRUTAL_FORM, v);
        return result;
    }

    @Deprecated
    public E findByVineFrutalForm(VineFrutalForm v) {
        return forVineFrutalFormEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByVineFrutalForm(VineFrutalForm v) {
        return forVineFrutalFormEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorSpreadModeIn(Collection<PollinatorSpreadMode> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedPerennialCropCycle.PROPERTY_POLLINATOR_SPREAD_MODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorSpreadModeEquals(PollinatorSpreadMode v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedPerennialCropCycle.PROPERTY_POLLINATOR_SPREAD_MODE, v);
        return result;
    }

    @Deprecated
    public E findByPollinatorSpreadMode(PollinatorSpreadMode v) {
        return forPollinatorSpreadModeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPollinatorSpreadMode(PollinatorSpreadMode v) {
        return forPollinatorSpreadModeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == PracticedCropCycleSpecies.class) {
            PracticedCropCycleSpeciesTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedCropCycleSpecies.class, PracticedCropCycleSpeciesTopiaDao.class);
            tmp = dao.forCycleEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(PracticedCropCycleSpecies.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedCropCycleSpecies.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getCropCyclePhases() != null) {
              tmp.addAll(entity.getCropCyclePhases());
           }
        if (entity.getPracticedCropCycleSpecies() != null) {
              tmp.addAll(entity.getPracticedCropCycleSpecies());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPracticedPerennialCropCycleTopiaDao<E extends PracticedPerennialCropCycle>
