package fr.inra.agrosyst.api.entities.practiced;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedPracticedInterventionTopiaDao<E extends PracticedIntervention> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) PracticedIntervention.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.PracticedIntervention;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            AbstractActionTopiaDao dao = topiaDaoSupplier
                    .getDao(AbstractAction.class, AbstractActionTopiaDao.class);
            List<AbstractAction> list = dao
                    .forProperties(AbstractAction.PROPERTY_PRACTICED_INTERVENTION, entity)
                    .findAll();
            for (AbstractAction item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPracticedIntervention())) {
                    item.setPracticedIntervention(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String name, String startingPeriodDate, String endingPeriodDate, AgrosystInterventionType type) {
        return create(PracticedIntervention.PROPERTY_NAME, name, PracticedIntervention.PROPERTY_STARTING_PERIOD_DATE, startingPeriodDate, PracticedIntervention.PROPERTY_ENDING_PERIOD_DATE, endingPeriodDate, PracticedIntervention.PROPERTY_TYPE, type);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRankIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_RANK, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRankEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_RANK, v);
        return result;
    }

    @Deprecated
    public E findByRank(int v) {
        return forRankEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRank(int v) {
        return forRankEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStartingPeriodDateIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_STARTING_PERIOD_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStartingPeriodDateEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_STARTING_PERIOD_DATE, v);
        return result;
    }

    @Deprecated
    public E findByStartingPeriodDate(String v) {
        return forStartingPeriodDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStartingPeriodDate(String v) {
        return forStartingPeriodDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndingPeriodDateIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_ENDING_PERIOD_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndingPeriodDateEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_ENDING_PERIOD_DATE, v);
        return result;
    }

    @Deprecated
    public E findByEndingPeriodDate(String v) {
        return forEndingPeriodDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEndingPeriodDate(String v) {
        return forEndingPeriodDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntermediateCropIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_INTERMEDIATE_CROP, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntermediateCropEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_INTERMEDIATE_CROP, v);
        return result;
    }

    @Deprecated
    public E findByIntermediateCrop(boolean v) {
        return forIntermediateCropEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByIntermediateCrop(boolean v) {
        return forIntermediateCropEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTillageDepthIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_TILLAGE_DEPTH, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTillageDepthEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_TILLAGE_DEPTH, v);
        return result;
    }

    @Deprecated
    public E findByTillageDepth(Integer v) {
        return forTillageDepthEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTillageDepth(Integer v) {
        return forTillageDepthEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherToolSettingsIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_OTHER_TOOL_SETTINGS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherToolSettingsEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_OTHER_TOOL_SETTINGS, v);
        return result;
    }

    @Deprecated
    public E findByOtherToolSettings(String v) {
        return forOtherToolSettingsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtherToolSettings(String v) {
        return forOtherToolSettingsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_WORK_RATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_WORK_RATE, v);
        return result;
    }

    @Deprecated
    public E findByWorkRate(Double v) {
        return forWorkRateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWorkRate(Double v) {
        return forWorkRateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProgressionSpeedIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_PROGRESSION_SPEED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProgressionSpeedEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_PROGRESSION_SPEED, v);
        return result;
    }

    @Deprecated
    public E findByProgressionSpeed(Integer v) {
        return forProgressionSpeedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProgressionSpeed(Integer v) {
        return forProgressionSpeedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInvolvedPeopleNumberIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_INVOLVED_PEOPLE_NUMBER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInvolvedPeopleNumberEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_INVOLVED_PEOPLE_NUMBER, v);
        return result;
    }

    @Deprecated
    public E findByInvolvedPeopleNumber(Double v) {
        return forInvolvedPeopleNumberEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByInvolvedPeopleNumber(Double v) {
        return forInvolvedPeopleNumberEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forToolsCouplingCodesContains(String v) {
        return forContains(PracticedIntervention.PROPERTY_TOOLS_COUPLING_CODES, v);
    }

    @Deprecated
    public E findContainsToolsCouplingCodes(String v) {
        return forToolsCouplingCodesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsToolsCouplingCodes(String v) {
        return forToolsCouplingCodesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpatialFrequencyIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_SPATIAL_FREQUENCY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpatialFrequencyEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_SPATIAL_FREQUENCY, v);
        return result;
    }

    @Deprecated
    public E findBySpatialFrequency(double v) {
        return forSpatialFrequencyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySpatialFrequency(double v) {
        return forSpatialFrequencyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTemporalFrequencyIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_TEMPORAL_FREQUENCY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTemporalFrequencyEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_TEMPORAL_FREQUENCY, v);
        return result;
    }

    @Deprecated
    public E findByTemporalFrequency(double v) {
        return forTemporalFrequencyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTemporalFrequency(double v) {
        return forTemporalFrequencyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_TRANSIT_VOLUME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_TRANSIT_VOLUME, v);
        return result;
    }

    @Deprecated
    public E findByTransitVolume(Double v) {
        return forTransitVolumeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTransitVolume(Double v) {
        return forTransitVolumeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNbBallsIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_NB_BALLS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNbBallsEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_NB_BALLS, v);
        return result;
    }

    @Deprecated
    public E findByNbBalls(Integer v) {
        return forNbBallsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByNbBalls(Integer v) {
        return forNbBallsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpeciesStadesContains(PracticedSpeciesStade v) {
        return forContains(PracticedIntervention.PROPERTY_SPECIES_STADES, v);
    }

    @Deprecated
    public E findContainsSpeciesStades(PracticedSpeciesStade v) {
        return forSpeciesStadesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsSpeciesStades(PracticedSpeciesStade v) {
        return forSpeciesStadesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedCropCyclePhaseIn(Collection<PracticedCropCyclePhase> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_PHASE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedCropCyclePhaseEquals(PracticedCropCyclePhase v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_PHASE, v);
        return result;
    }

    @Deprecated
    public E findByPracticedCropCyclePhase(PracticedCropCyclePhase v) {
        return forPracticedCropCyclePhaseEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPracticedCropCyclePhase(PracticedCropCyclePhase v) {
        return forPracticedCropCyclePhaseEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedCropCycleConnectionIn(Collection<PracticedCropCycleConnection> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedCropCycleConnectionEquals(PracticedCropCycleConnection v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION, v);
        return result;
    }

    @Deprecated
    public E findByPracticedCropCycleConnection(PracticedCropCycleConnection v) {
        return forPracticedCropCycleConnectionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPracticedCropCycleConnection(PracticedCropCycleConnection v) {
        return forPracticedCropCycleConnectionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<AgrosystInterventionType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(AgrosystInterventionType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(AgrosystInterventionType v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(AgrosystInterventionType v) {
        return forTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateUnitIn(Collection<MaterielWorkRateUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_WORK_RATE_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateUnitEquals(MaterielWorkRateUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_WORK_RATE_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByWorkRateUnit(MaterielWorkRateUnit v) {
        return forWorkRateUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWorkRateUnit(MaterielWorkRateUnit v) {
        return forWorkRateUnitEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeUnitIn(Collection<MaterielTransportUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedIntervention.PROPERTY_TRANSIT_VOLUME_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeUnitEquals(MaterielTransportUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedIntervention.PROPERTY_TRANSIT_VOLUME_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByTransitVolumeUnit(MaterielTransportUnit v) {
        return forTransitVolumeUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTransitVolumeUnit(MaterielTransportUnit v) {
        return forTransitVolumeUnitEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == AbstractAction.class) {
            AbstractActionTopiaDao dao =
                topiaDaoSupplier.getDao(AbstractAction.class, AbstractActionTopiaDao.class);
            tmp = dao.forPracticedInterventionEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(AbstractAction.class, entity);
        if (!list.isEmpty()) {
            result.put(AbstractAction.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getSpeciesStades() != null) {
              tmp.addAll(entity.getSpeciesStades());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPracticedInterventionTopiaDao<E extends PracticedIntervention>
