package fr.inra.agrosyst.api.entities.practiced;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedPracticedCropCycleNodeTopiaDao<E extends PracticedCropCycleNode> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) PracticedCropCycleNode.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.PracticedCropCycleNode;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PracticedCropCycleConnectionTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedCropCycleConnection.class, PracticedCropCycleConnectionTopiaDao.class);
            List<PracticedCropCycleConnection> list = dao
                    .forProperties(PracticedCropCycleConnection.PROPERTY_TARGET, entity)
                    .findAll();
            for (PracticedCropCycleConnection item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getTarget())) {
                    item.setTarget(null);
                }
            
            }
        }

        {
            PracticedCropCycleConnectionTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedCropCycleConnection.class, PracticedCropCycleConnectionTopiaDao.class);
            List<PracticedCropCycleConnection> list = dao
                    .forProperties(PracticedCropCycleConnection.PROPERTY_SOURCE, entity)
                    .findAll();
            for (PracticedCropCycleConnection item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSource())) {
                    item.setSource(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(int rank, int y, String croppingPlanEntryCode, PracticedSeasonalCropCycle practicedSeasonalCropCycle) {
        return create(PracticedCropCycleNode.PROPERTY_RANK, rank, PracticedCropCycleNode.PROPERTY_Y, y, PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE, croppingPlanEntryCode, PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE, practicedSeasonalCropCycle);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRankIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleNode.PROPERTY_RANK, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRankEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleNode.PROPERTY_RANK, v);
        return result;
    }

    @Deprecated
    public E findByRank(int v) {
        return forRankEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRank(int v) {
        return forRankEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forYIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleNode.PROPERTY_Y, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forYEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleNode.PROPERTY_Y, v);
        return result;
    }

    @Deprecated
    public E findByY(int v) {
        return forYEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByY(int v) {
        return forYEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndCycleIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleNode.PROPERTY_END_CYCLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndCycleEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleNode.PROPERTY_END_CYCLE, v);
        return result;
    }

    @Deprecated
    public E findByEndCycle(boolean v) {
        return forEndCycleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEndCycle(boolean v) {
        return forEndCycleEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanEntryCode(String v) {
        return forCroppingPlanEntryCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanEntryCode(String v) {
        return forCroppingPlanEntryCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSameCampaignAsPreviousNodeIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleNode.PROPERTY_SAME_CAMPAIGN_AS_PREVIOUS_NODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSameCampaignAsPreviousNodeEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleNode.PROPERTY_SAME_CAMPAIGN_AS_PREVIOUS_NODE, v);
        return result;
    }

    @Deprecated
    public E findBySameCampaignAsPreviousNode(boolean v) {
        return forSameCampaignAsPreviousNodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySameCampaignAsPreviousNode(boolean v) {
        return forSameCampaignAsPreviousNodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInitNodeFrequencyIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleNode.PROPERTY_INIT_NODE_FREQUENCY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInitNodeFrequencyEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleNode.PROPERTY_INIT_NODE_FREQUENCY, v);
        return result;
    }

    @Deprecated
    public E findByInitNodeFrequency(Double v) {
        return forInitNodeFrequencyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByInitNodeFrequency(Double v) {
        return forInitNodeFrequencyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedSeasonalCropCycleIn(Collection<PracticedSeasonalCropCycle> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedSeasonalCropCycleEquals(PracticedSeasonalCropCycle v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE, v);
        return result;
    }

    @Deprecated
    public E findByPracticedSeasonalCropCycle(PracticedSeasonalCropCycle v) {
        return forPracticedSeasonalCropCycleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPracticedSeasonalCropCycle(PracticedSeasonalCropCycle v) {
        return forPracticedSeasonalCropCycleEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == PracticedCropCycleConnection.class) {
            PracticedCropCycleConnectionTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedCropCycleConnection.class, PracticedCropCycleConnectionTopiaDao.class);
            tmp = dao.forTargetEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == PracticedCropCycleConnection.class) {
            PracticedCropCycleConnectionTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedCropCycleConnection.class, PracticedCropCycleConnectionTopiaDao.class);
            tmp = dao.forSourceEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == PracticedSeasonalCropCycle.class) {
            PracticedSeasonalCropCycleTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedSeasonalCropCycle.class, PracticedSeasonalCropCycleTopiaDao.class);
            tmp = dao.forCropCycleNodesContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(PracticedCropCycleConnection.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedCropCycleConnection.class, list);
        }

        list = findUsages(PracticedSeasonalCropCycle.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedSeasonalCropCycle.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPracticedCropCycleNodeTopiaDao<E extends PracticedCropCycleNode>
