package fr.inra.agrosyst.api.entities.practiced;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedPracticedCropCycleConnectionTopiaDao<E extends PracticedCropCycleConnection> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) PracticedCropCycleConnection.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.PracticedCropCycleConnection;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PracticedInterventionTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedIntervention.class, PracticedInterventionTopiaDao.class);
            List<PracticedIntervention> list = dao
                    .forProperties(PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION, entity)
                    .findAll();
            for (PracticedIntervention item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPracticedCropCycleConnection())) {
                    item.setPracticedCropCycleConnection(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(PracticedCropCycleNode target, PracticedCropCycleNode source) {
        return create(PracticedCropCycleConnection.PROPERTY_TARGET, target, PracticedCropCycleConnection.PROPERTY_SOURCE, source);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntermediateCroppingPlanEntryCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleConnection.PROPERTY_INTERMEDIATE_CROPPING_PLAN_ENTRY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntermediateCroppingPlanEntryCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleConnection.PROPERTY_INTERMEDIATE_CROPPING_PLAN_ENTRY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByIntermediateCroppingPlanEntryCode(String v) {
        return forIntermediateCroppingPlanEntryCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByIntermediateCroppingPlanEntryCode(String v) {
        return forIntermediateCroppingPlanEntryCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryFrequencyIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleConnection.PROPERTY_CROPPING_PLAN_ENTRY_FREQUENCY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryFrequencyEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleConnection.PROPERTY_CROPPING_PLAN_ENTRY_FREQUENCY, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanEntryFrequency(double v) {
        return forCroppingPlanEntryFrequencyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanEntryFrequency(double v) {
        return forCroppingPlanEntryFrequencyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNotUsedForThisCampaignIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleConnection.PROPERTY_NOT_USED_FOR_THIS_CAMPAIGN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNotUsedForThisCampaignEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleConnection.PROPERTY_NOT_USED_FOR_THIS_CAMPAIGN, v);
        return result;
    }

    @Deprecated
    public E findByNotUsedForThisCampaign(boolean v) {
        return forNotUsedForThisCampaignEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByNotUsedForThisCampaign(boolean v) {
        return forNotUsedForThisCampaignEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTargetIn(Collection<PracticedCropCycleNode> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleConnection.PROPERTY_TARGET, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTargetEquals(PracticedCropCycleNode v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleConnection.PROPERTY_TARGET, v);
        return result;
    }

    @Deprecated
    public E findByTarget(PracticedCropCycleNode v) {
        return forTargetEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTarget(PracticedCropCycleNode v) {
        return forTargetEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<PracticedCropCycleNode> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PracticedCropCycleConnection.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(PracticedCropCycleNode v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PracticedCropCycleConnection.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(PracticedCropCycleNode v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(PracticedCropCycleNode v) {
        return forSourceEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == PracticedIntervention.class) {
            PracticedInterventionTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedIntervention.class, PracticedInterventionTopiaDao.class);
            tmp = dao.forPracticedCropCycleConnectionEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(PracticedIntervention.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedIntervention.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPracticedCropCycleConnectionTopiaDao<E extends PracticedCropCycleConnection>
