package fr.inra.agrosyst.api.entities.performance;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedPerformanceTopiaDao<E extends Performance> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Performance.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Performance;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PerformanceFileTopiaDao dao = topiaDaoSupplier
                    .getDao(PerformanceFile.class, PerformanceFileTopiaDao.class);
            List<PerformanceFile> list = dao
                    .forProperties(PerformanceFile.PROPERTY_PERFORMANCE, entity)
                    .findAll();
            for (PerformanceFile item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPerformance())) {
                    item.setPerformance(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String name, Date updateDate, AgrosystUser author, PerformanceState computeStatus) {
        return create(Performance.PROPERTY_NAME, name, Performance.PROPERTY_UPDATE_DATE, updateDate, Performance.PROPERTY_AUTHOR, author, Performance.PROPERTY_COMPUTE_STATUS, computeStatus);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Performance.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Performance.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Performance.PROPERTY_PRACTICED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Performance.PROPERTY_PRACTICED, v);
        return result;
    }

    @Deprecated
    public E findByPracticed(boolean v) {
        return forPracticedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPracticed(boolean v) {
        return forPracticedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUpdateDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Performance.PROPERTY_UPDATE_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUpdateDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Performance.PROPERTY_UPDATE_DATE, v);
        return result;
    }

    @Deprecated
    public E findByUpdateDate(Date v) {
        return forUpdateDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUpdateDate(Date v) {
        return forUpdateDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainsContains(Domain v) {
        return forContains(Performance.PROPERTY_DOMAINS, v);
    }

    @Deprecated
    public E findContainsDomains(Domain v) {
        return forDomainsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsDomains(Domain v) {
        return forDomainsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlotsContains(Plot v) {
        return forContains(Performance.PROPERTY_PLOTS, v);
    }

    @Deprecated
    public E findContainsPlots(Plot v) {
        return forPlotsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsPlots(Plot v) {
        return forPlotsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forZonesContains(Zone v) {
        return forContains(Performance.PROPERTY_ZONES, v);
    }

    @Deprecated
    public E findContainsZones(Zone v) {
        return forZonesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsZones(Zone v) {
        return forZonesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAuthorIn(Collection<AgrosystUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Performance.PROPERTY_AUTHOR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAuthorEquals(AgrosystUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Performance.PROPERTY_AUTHOR, v);
        return result;
    }

    @Deprecated
    public E findByAuthor(AgrosystUser v) {
        return forAuthorEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAuthor(AgrosystUser v) {
        return forAuthorEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forComputeStatusIn(Collection<PerformanceState> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Performance.PROPERTY_COMPUTE_STATUS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forComputeStatusEquals(PerformanceState v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Performance.PROPERTY_COMPUTE_STATUS, v);
        return result;
    }

    @Deprecated
    public E findByComputeStatus(PerformanceState v) {
        return forComputeStatusEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComputeStatus(PerformanceState v) {
        return forComputeStatusEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGrowingSystemsContains(GrowingSystem v) {
        return forContains(Performance.PROPERTY_GROWING_SYSTEMS, v);
    }

    @Deprecated
    public E findContainsGrowingSystems(GrowingSystem v) {
        return forGrowingSystemsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsGrowingSystems(GrowingSystem v) {
        return forGrowingSystemsContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == PerformanceFile.class) {
            PerformanceFileTopiaDao dao =
                topiaDaoSupplier.getDao(PerformanceFile.class, PerformanceFileTopiaDao.class);
            tmp = dao.forPerformanceEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(PerformanceFile.class, entity);
        if (!list.isEmpty()) {
            result.put(PerformanceFile.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPerformanceTopiaDao<E extends Performance>
