package fr.inra.agrosyst.api.entities.measure;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedMeasurementTopiaDao<E extends Measurement> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Measurement.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Measurement;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(MeasurementType measurementType) {
        return create(Measurement.PROPERTY_MEASUREMENT_TYPE, measurementType);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasuringProtocolIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measurement.PROPERTY_MEASURING_PROTOCOL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasuringProtocolEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measurement.PROPERTY_MEASURING_PROTOCOL, v);
        return result;
    }

    @Deprecated
    public E findByMeasuringProtocol(String v) {
        return forMeasuringProtocolEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMeasuringProtocol(String v) {
        return forMeasuringProtocolEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRepetitionNumberIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measurement.PROPERTY_REPETITION_NUMBER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRepetitionNumberEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measurement.PROPERTY_REPETITION_NUMBER, v);
        return result;
    }

    @Deprecated
    public E findByRepetitionNumber(Integer v) {
        return forRepetitionNumberEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRepetitionNumber(Integer v) {
        return forRepetitionNumberEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measurement.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measurement.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasurementTypeIn(Collection<MeasurementType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measurement.PROPERTY_MEASUREMENT_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasurementTypeEquals(MeasurementType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measurement.PROPERTY_MEASUREMENT_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByMeasurementType(MeasurementType v) {
        return forMeasurementTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMeasurementType(MeasurementType v) {
        return forMeasurementTypeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == MeasurementSession.class) {
            MeasurementSessionTopiaDao dao =
                topiaDaoSupplier.getDao(MeasurementSession.class, MeasurementSessionTopiaDao.class);
            tmp = dao.forMeasurementsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveIntervention.class) {
            EffectiveInterventionTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveIntervention.class, EffectiveInterventionTopiaDao.class);
            tmp = dao.forMeasurementsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(MeasurementSession.class, entity);
        if (!list.isEmpty()) {
            result.put(MeasurementSession.class, list);
        }

        list = findUsages(EffectiveIntervention.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveIntervention.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedMeasurementTopiaDao<E extends Measurement>
