package fr.inra.agrosyst.api.entities.measure;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Zone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedMeasurementSessionTopiaDao<E extends MeasurementSession> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) MeasurementSession.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.MeasurementSession;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(Date startDate, Zone zone) {
        return create(MeasurementSession.PROPERTY_START_DATE, startDate, MeasurementSession.PROPERTY_ZONE, zone);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStartDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MeasurementSession.PROPERTY_START_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStartDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MeasurementSession.PROPERTY_START_DATE, v);
        return result;
    }

    @Deprecated
    public E findByStartDate(Date v) {
        return forStartDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStartDate(Date v) {
        return forStartDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MeasurementSession.PROPERTY_END_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MeasurementSession.PROPERTY_END_DATE, v);
        return result;
    }

    @Deprecated
    public E findByEndDate(Date v) {
        return forEndDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEndDate(Date v) {
        return forEndDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MeasurementSession.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MeasurementSession.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMinStageIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MeasurementSession.PROPERTY_MIN_STAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMinStageEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MeasurementSession.PROPERTY_MIN_STAGE, v);
        return result;
    }

    @Deprecated
    public E findByMinStage(String v) {
        return forMinStageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMinStage(String v) {
        return forMinStageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMaxStageIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MeasurementSession.PROPERTY_MAX_STAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMaxStageEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MeasurementSession.PROPERTY_MAX_STAGE, v);
        return result;
    }

    @Deprecated
    public E findByMaxStage(String v) {
        return forMaxStageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMaxStage(String v) {
        return forMaxStageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasurementsContains(Measurement v) {
        return forContains(MeasurementSession.PROPERTY_MEASUREMENTS, v);
    }

    @Deprecated
    public E findContainsMeasurements(Measurement v) {
        return forMeasurementsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsMeasurements(Measurement v) {
        return forMeasurementsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forZoneIn(Collection<Zone> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MeasurementSession.PROPERTY_ZONE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forZoneEquals(Zone v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MeasurementSession.PROPERTY_ZONE, v);
        return result;
    }

    @Deprecated
    public E findByZone(Zone v) {
        return forZoneEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByZone(Zone v) {
        return forZoneEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryIn(Collection<CroppingPlanEntry> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MeasurementSession.PROPERTY_CROPPING_PLAN_ENTRY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryEquals(CroppingPlanEntry v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MeasurementSession.PROPERTY_CROPPING_PLAN_ENTRY, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanEntry(CroppingPlanEntry v) {
        return forCroppingPlanEntryEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanEntry(CroppingPlanEntry v) {
        return forCroppingPlanEntryEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getMeasurements() != null) {
              tmp.addAll(entity.getMeasurements());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedMeasurementSessionTopiaDao<E extends MeasurementSession>
