package fr.inra.agrosyst.api.entities.measure;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedMeasureTopiaDao<E extends Measure> extends AbstractMeasurementTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Measure.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Measure;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(MeasurementType measurementType) {
        return create(Measure.PROPERTY_MEASUREMENT_TYPE, measurementType);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEffectiveOrAreaTakenIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_EFFECTIVE_OR_AREA_TAKEN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEffectiveOrAreaTakenEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_EFFECTIVE_OR_AREA_TAKEN, v);
        return result;
    }

    @Deprecated
    public E findByEffectiveOrAreaTaken(String v) {
        return forEffectiveOrAreaTakenEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEffectiveOrAreaTaken(String v) {
        return forEffectiveOrAreaTakenEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasureValueIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_MEASURE_VALUE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasureValueEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_MEASURE_VALUE, v);
        return result;
    }

    @Deprecated
    public E findByMeasureValue(String v) {
        return forMeasureValueEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMeasureValue(String v) {
        return forMeasureValueEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasureUnitIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_MEASURE_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasureUnitEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_MEASURE_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByMeasureUnit(String v) {
        return forMeasureUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMeasureUnit(String v) {
        return forMeasureUnitEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSamplingIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_SAMPLING, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSamplingEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_SAMPLING, v);
        return result;
    }

    @Deprecated
    public E findBySampling(String v) {
        return forSamplingEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySampling(String v) {
        return forSamplingEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasureTypeIn(Collection<MeasureType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_MEASURE_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasureTypeEquals(MeasureType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_MEASURE_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByMeasureType(MeasureType v) {
        return forMeasureTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMeasureType(MeasureType v) {
        return forMeasureTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRefMesureIn(Collection<RefMesure> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_REF_MESURE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRefMesureEquals(RefMesure v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_REF_MESURE, v);
        return result;
    }

    @Deprecated
    public E findByRefMesure(RefMesure v) {
        return forRefMesureEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRefMesure(RefMesure v) {
        return forRefMesureEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forChemicalElementIn(Collection<ChemicalElement> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_CHEMICAL_ELEMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forChemicalElementEquals(ChemicalElement v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_CHEMICAL_ELEMENT, v);
        return result;
    }

    @Deprecated
    public E findByChemicalElement(ChemicalElement v) {
        return forChemicalElementEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByChemicalElement(ChemicalElement v) {
        return forChemicalElementEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProductivityTypeIn(Collection<ProductivityType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_PRODUCTIVITY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProductivityTypeEquals(ProductivityType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_PRODUCTIVITY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByProductivityType(ProductivityType v) {
        return forProductivityTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProductivityType(ProductivityType v) {
        return forProductivityTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHorizonTypeIn(Collection<HorizonType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_HORIZON_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHorizonTypeEquals(HorizonType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_HORIZON_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByHorizonType(HorizonType v) {
        return forHorizonTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByHorizonType(HorizonType v) {
        return forHorizonTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNitrogenMoleculeIn(Collection<NitrogenMolecule> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_NITROGEN_MOLECULE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNitrogenMoleculeEquals(NitrogenMolecule v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_NITROGEN_MOLECULE, v);
        return result;
    }

    @Deprecated
    public E findByNitrogenMolecule(NitrogenMolecule v) {
        return forNitrogenMoleculeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByNitrogenMolecule(NitrogenMolecule v) {
        return forNitrogenMoleculeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganSupportIn(Collection<RefSupportOrganeEDI> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_ORGAN_SUPPORT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganSupportEquals(RefSupportOrganeEDI v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_ORGAN_SUPPORT, v);
        return result;
    }

    @Deprecated
    public E findByOrganSupport(RefSupportOrganeEDI v) {
        return forOrganSupportEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrganSupport(RefSupportOrganeEDI v) {
        return forOrganSupportEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanSpeciesIn(Collection<CroppingPlanSpecies> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_CROPPING_PLAN_SPECIES, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanSpeciesEquals(CroppingPlanSpecies v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_CROPPING_PLAN_SPECIES, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanSpecies(CroppingPlanSpecies v) {
        return forCroppingPlanSpeciesEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanSpecies(CroppingPlanSpecies v) {
        return forCroppingPlanSpeciesEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveSubstanceIn(Collection<RefActaSubstanceActive> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Measure.PROPERTY_ACTIVE_SUBSTANCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveSubstanceEquals(RefActaSubstanceActive v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Measure.PROPERTY_ACTIVE_SUBSTANCE, v);
        return result;
    }

    @Deprecated
    public E findByActiveSubstance(RefActaSubstanceActive v) {
        return forActiveSubstanceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActiveSubstance(RefActaSubstanceActive v) {
        return forActiveSubstanceEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedMeasureTopiaDao<E extends Measure>
