package fr.inra.agrosyst.api.entities.managementmode;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.effective.EffectiveInvolvedRule;
import fr.inra.agrosyst.api.entities.effective.EffectiveInvolvedRuleTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedDecisionRuleTopiaDao<E extends DecisionRule> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) DecisionRule.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.DecisionRule;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM strategy main, rules_strategy secondary " +
                    " WHERE main.topiaId=secondary.strategy " +
                    " AND secondary.rules='" + entity.getTopiaId() + "'";
            List<Strategy> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.Strategy.getImplementation())
                    .list();

            for (Strategy item : list) {
                item.removeRules(entity);
            }
        }

        {
            EffectiveInvolvedRuleTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveInvolvedRule.class, EffectiveInvolvedRuleTopiaDao.class);
            List<EffectiveInvolvedRule> list = dao
                    .forProperties(EffectiveInvolvedRule.PROPERTY_DECISION_RULE, entity)
                    .findAll();
            for (EffectiveInvolvedRule item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDecisionRule())) {
                    item.setDecisionRule(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String code, int versionNumber) {
        return forNaturalId(code, versionNumber).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String code, int versionNumber) {
        return forNaturalId(code, versionNumber).exists();
    }

    public E createByNaturalId(String code, int versionNumber) {
        return create(DecisionRule.PROPERTY_CODE, code, DecisionRule.PROPERTY_VERSION_NUMBER, versionNumber);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String code, int versionNumber) {
        return forProperties(DecisionRule.PROPERTY_CODE, code, DecisionRule.PROPERTY_VERSION_NUMBER, versionNumber);
    }

    public E createByNotNull(String code, int versionNumber, String domainCode, String name, AgrosystInterventionType interventionType) {
        return create(DecisionRule.PROPERTY_CODE, code, DecisionRule.PROPERTY_VERSION_NUMBER, versionNumber, DecisionRule.PROPERTY_DOMAIN_CODE, domainCode, DecisionRule.PROPERTY_NAME, name, DecisionRule.PROPERTY_INTERVENTION_TYPE, interventionType);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVersionNumberIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_VERSION_NUMBER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVersionNumberEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_VERSION_NUMBER, v);
        return result;
    }

    @Deprecated
    public E findByVersionNumber(int v) {
        return forVersionNumberEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByVersionNumber(int v) {
        return forVersionNumberEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_DOMAIN_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_DOMAIN_CODE, v);
        return result;
    }

    @Deprecated
    public E findByDomainCode(String v) {
        return forDomainCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDomainCode(String v) {
        return forDomainCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainValidityIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_DOMAIN_VALIDITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainValidityEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_DOMAIN_VALIDITY, v);
        return result;
    }

    @Deprecated
    public E findByDomainValidity(String v) {
        return forDomainValidityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDomainValidity(String v) {
        return forDomainValidityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDecisionObjectIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_DECISION_OBJECT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDecisionObjectEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_DECISION_OBJECT, v);
        return result;
    }

    @Deprecated
    public E findByDecisionObject(String v) {
        return forDecisionObjectEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDecisionObject(String v) {
        return forDecisionObjectEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_SOURCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSourceEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_SOURCE, v);
        return result;
    }

    @Deprecated
    public E findBySource(String v) {
        return forSourceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySource(String v) {
        return forSourceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUsageCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_USAGE_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUsageCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_USAGE_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByUsageComment(String v) {
        return forUsageCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUsageComment(String v) {
        return forUsageCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forObjectiveIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_OBJECTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forObjectiveEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_OBJECTIVE, v);
        return result;
    }

    @Deprecated
    public E findByObjective(String v) {
        return forObjectiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByObjective(String v) {
        return forObjectiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExpectedResultIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_EXPECTED_RESULT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExpectedResultEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_EXPECTED_RESULT, v);
        return result;
    }

    @Deprecated
    public E findByExpectedResult(String v) {
        return forExpectedResultEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByExpectedResult(String v) {
        return forExpectedResultEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSolutionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_SOLUTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSolutionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_SOLUTION, v);
        return result;
    }

    @Deprecated
    public E findBySolution(String v) {
        return forSolutionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySolution(String v) {
        return forSolutionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDecisionCriteriaIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_DECISION_CRITERIA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDecisionCriteriaEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_DECISION_CRITERIA, v);
        return result;
    }

    @Deprecated
    public E findByDecisionCriteria(String v) {
        return forDecisionCriteriaEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDecisionCriteria(String v) {
        return forDecisionCriteriaEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forObservationIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_OBSERVATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forObservationEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_OBSERVATION, v);
        return result;
    }

    @Deprecated
    public E findByObservation(String v) {
        return forObservationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByObservation(String v) {
        return forObservationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forResultCriteriaIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_RESULT_CRITERIA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forResultCriteriaEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_RESULT_CRITERIA, v);
        return result;
    }

    @Deprecated
    public E findByResultCriteria(String v) {
        return forResultCriteriaEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByResultCriteria(String v) {
        return forResultCriteriaEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSolutionCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_SOLUTION_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSolutionCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_SOLUTION_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findBySolutionComment(String v) {
        return forSolutionCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySolutionComment(String v) {
        return forSolutionCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVersionReasonIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_VERSION_REASON, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVersionReasonEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_VERSION_REASON, v);
        return result;
    }

    @Deprecated
    public E findByVersionReason(String v) {
        return forVersionReasonEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByVersionReason(String v) {
        return forVersionReasonEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_CROPPING_PLAN_ENTRY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_CROPPING_PLAN_ENTRY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanEntryCode(String v) {
        return forCroppingPlanEntryCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanEntryCode(String v) {
        return forCroppingPlanEntryCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInterventionTypeIn(Collection<AgrosystInterventionType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_INTERVENTION_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInterventionTypeEquals(AgrosystInterventionType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_INTERVENTION_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByInterventionType(AgrosystInterventionType v) {
        return forInterventionTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByInterventionType(AgrosystInterventionType v) {
        return forInterventionTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBioAgressorIn(Collection<RefBioAgressor> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_BIO_AGRESSOR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBioAgressorEquals(RefBioAgressor v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_BIO_AGRESSOR, v);
        return result;
    }

    @Deprecated
    public E findByBioAgressor(RefBioAgressor v) {
        return forBioAgressorEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByBioAgressor(RefBioAgressor v) {
        return forBioAgressorEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBioAgressorTypeIn(Collection<BioAgressorType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(DecisionRule.PROPERTY_BIO_AGRESSOR_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBioAgressorTypeEquals(BioAgressorType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(DecisionRule.PROPERTY_BIO_AGRESSOR_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByBioAgressorType(BioAgressorType v) {
        return forBioAgressorTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByBioAgressorType(BioAgressorType v) {
        return forBioAgressorTypeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Strategy.class) {
            StrategyTopiaDao dao =
                topiaDaoSupplier.getDao(Strategy.class, StrategyTopiaDao.class);
            tmp = dao.forRulesContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveInvolvedRule.class) {
            EffectiveInvolvedRuleTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveInvolvedRule.class, EffectiveInvolvedRuleTopiaDao.class);
            tmp = dao.forDecisionRuleEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Strategy.class, entity);
        if (!list.isEmpty()) {
            result.put(Strategy.class, list);
        }

        list = findUsages(EffectiveInvolvedRule.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveInvolvedRule.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedDecisionRuleTopiaDao<E extends DecisionRule>
