package fr.inra.agrosyst.api.entities.history;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: MessageTopiaDao.java 4612 2014-12-06 18:43:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/history/MessageTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.history.MessageFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;
import org.nuiton.util.PagerBean;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * Created by davidcosse on 14/10/14.
 */
public class MessageTopiaDao extends AbstractMessageTopiaDao<Message> {

    public ResultList<Message> getAllMessageByPage(MessageFilter filter) {
        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;

        String query = "FROM " + getEntityClass().getName() + " M WHERE 1 = 1 ";
        String orderedQuery = query + " ORDER BY M." + Message.PROPERTY_MESSAGE_DATE + " DESC";

        List<Message> messages = find(orderedQuery, new HashMap<String, Object>(), startIndex, endIndex);
        long totalCount = findUnique("SELECT count(*) " + query, new HashMap<String, Object>());

        // build result bean
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList<Message> result = ResultList.of(messages, pager);
        return result;
    }

    public List<Message> geAllMessages() {
        StringBuilder query = new StringBuilder("FROM " + getEntityClass().getName() + " M");
        query.append(" WHERE 1 = 1");
        query.append(" ORDER BY M." + Message.PROPERTY_MESSAGE_DATE + " DESC");

        List<Message> result = findAll(query.toString(), new HashMap<String, Object>());
        return result;
    }


    public List<Message> geMessageFromDate(Date fromDate) {

        StringBuilder query = new StringBuilder("FROM " + getEntityClass().getName() + " M");
        query.append(" WHERE 1 = 1");

        query.append(" AND M." + Message.PROPERTY_MESSAGE_DATE + " > :fromDate");
        query.append(" ORDER BY M." + Message.PROPERTY_MESSAGE_DATE + " DESC");

        List<Message> result = findAll(query.toString(), DaoUtils.asArgsMap("fromDate", fromDate));
        return result;
    }

    public Date getLastMassageDate() {
        String query = "FROM " + getEntityClass().getName() + " M WHERE 1 = 1 ";
        String orderedQuery = query + " ORDER BY M." + Message.PROPERTY_MESSAGE_DATE + " DESC";

        List<Message> messages = findAll(orderedQuery, new HashMap<String, Object>());
        Date result = null;
        if (messages != null && !messages.isEmpty()) {
            result = messages.get(0).getMessageDate();
        }

        return result;
    }
}
