package fr.inra.agrosyst.api.entities.effective;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.OrchardFrutalForm;
import fr.inra.agrosyst.api.entities.PollinatorSpreadMode;
import fr.inra.agrosyst.api.entities.VineFrutalForm;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedEffectivePerennialCropCycleTopiaDao<E extends EffectivePerennialCropCycle> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) EffectivePerennialCropCycle.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.EffectivePerennialCropCycle;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(WeedType weedType, Zone zone, CroppingPlanEntry croppingPlanEntry, EffectiveCropCyclePhase phase) {
        return create(EffectivePerennialCropCycle.PROPERTY_WEED_TYPE, weedType, EffectivePerennialCropCycle.PROPERTY_ZONE, zone, EffectivePerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY, croppingPlanEntry, EffectivePerennialCropCycle.PROPERTY_PHASE, phase);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingYearIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_PLANTING_YEAR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingYearEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_PLANTING_YEAR, v);
        return result;
    }

    @Deprecated
    public E findByPlantingYear(Integer v) {
        return forPlantingYearEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingYear(Integer v) {
        return forPlantingYearEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDensityIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_PLANTING_DENSITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDensityEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_PLANTING_DENSITY, v);
        return result;
    }

    @Deprecated
    public E findByPlantingDensity(Double v) {
        return forPlantingDensityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingDensity(Double v) {
        return forPlantingDensityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingInterFurrowIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_PLANTING_INTER_FURROW, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingInterFurrowEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_PLANTING_INTER_FURROW, v);
        return result;
    }

    @Deprecated
    public E findByPlantingInterFurrow(Integer v) {
        return forPlantingInterFurrowEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingInterFurrow(Integer v) {
        return forPlantingInterFurrowEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingSpacingIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_PLANTING_SPACING, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingSpacingEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_PLANTING_SPACING, v);
        return result;
    }

    @Deprecated
    public E findByPlantingSpacing(Integer v) {
        return forPlantingSpacingEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingSpacing(Integer v) {
        return forPlantingSpacingEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDeathRateIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDeathRateEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE, v);
        return result;
    }

    @Deprecated
    public E findByPlantingDeathRate(Double v) {
        return forPlantingDeathRateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingDeathRate(Double v) {
        return forPlantingDeathRateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDeathRateMeasureYearIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlantingDeathRateMeasureYearEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR, v);
        return result;
    }

    @Deprecated
    public E findByPlantingDeathRateMeasureYear(Integer v) {
        return forPlantingDeathRateMeasureYearEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlantingDeathRateMeasureYear(Integer v) {
        return forPlantingDeathRateMeasureYearEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_POLLINATOR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_POLLINATOR, v);
        return result;
    }

    @Deprecated
    public E findByPollinator(boolean v) {
        return forPollinatorEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPollinator(boolean v) {
        return forPollinatorEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorPercentIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_POLLINATOR_PERCENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorPercentEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_POLLINATOR_PERCENT, v);
        return result;
    }

    @Deprecated
    public E findByPollinatorPercent(Double v) {
        return forPollinatorPercentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPollinatorPercent(Double v) {
        return forPollinatorPercentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherCharacteristicsIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_OTHER_CHARACTERISTICS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherCharacteristicsEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_OTHER_CHARACTERISTICS, v);
        return result;
    }

    @Deprecated
    public E findByOtherCharacteristics(String v) {
        return forOtherCharacteristicsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtherCharacteristics(String v) {
        return forOtherCharacteristicsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFoliageHeightIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_FOLIAGE_HEIGHT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFoliageHeightEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_FOLIAGE_HEIGHT, v);
        return result;
    }

    @Deprecated
    public E findByFoliageHeight(Double v) {
        return forFoliageHeightEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFoliageHeight(Double v) {
        return forFoliageHeightEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFoliageThicknessIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_FOLIAGE_THICKNESS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFoliageThicknessEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_FOLIAGE_THICKNESS, v);
        return result;
    }

    @Deprecated
    public E findByFoliageThickness(Double v) {
        return forFoliageThicknessEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFoliageThickness(Double v) {
        return forFoliageThicknessEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdaplosIssuerIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_EDAPLOS_ISSUER_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdaplosIssuerIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_EDAPLOS_ISSUER_ID, v);
        return result;
    }

    @Deprecated
    public E findByEdaplosIssuerId(String v) {
        return forEdaplosIssuerIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEdaplosIssuerId(String v) {
        return forEdaplosIssuerIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrientationIn(Collection<RefOrientationEDI> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_ORIENTATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrientationEquals(RefOrientationEDI v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_ORIENTATION, v);
        return result;
    }

    @Deprecated
    public E findByOrientation(RefOrientationEDI v) {
        return forOrientationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrientation(RefOrientationEDI v) {
        return forOrientationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorSpreadModeIn(Collection<PollinatorSpreadMode> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_POLLINATOR_SPREAD_MODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPollinatorSpreadModeEquals(PollinatorSpreadMode v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_POLLINATOR_SPREAD_MODE, v);
        return result;
    }

    @Deprecated
    public E findByPollinatorSpreadMode(PollinatorSpreadMode v) {
        return forPollinatorSpreadModeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPollinatorSpreadMode(PollinatorSpreadMode v) {
        return forPollinatorSpreadModeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWeedTypeIn(Collection<WeedType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_WEED_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWeedTypeEquals(WeedType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_WEED_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByWeedType(WeedType v) {
        return forWeedTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWeedType(WeedType v) {
        return forWeedTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrchardFrutalFormIn(Collection<OrchardFrutalForm> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_ORCHARD_FRUTAL_FORM, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrchardFrutalFormEquals(OrchardFrutalForm v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_ORCHARD_FRUTAL_FORM, v);
        return result;
    }

    @Deprecated
    public E findByOrchardFrutalForm(OrchardFrutalForm v) {
        return forOrchardFrutalFormEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrchardFrutalForm(OrchardFrutalForm v) {
        return forOrchardFrutalFormEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVineFrutalFormIn(Collection<VineFrutalForm> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_VINE_FRUTAL_FORM, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVineFrutalFormEquals(VineFrutalForm v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_VINE_FRUTAL_FORM, v);
        return result;
    }

    @Deprecated
    public E findByVineFrutalForm(VineFrutalForm v) {
        return forVineFrutalFormEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByVineFrutalForm(VineFrutalForm v) {
        return forVineFrutalFormEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forZoneIn(Collection<Zone> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_ZONE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forZoneEquals(Zone v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_ZONE, v);
        return result;
    }

    @Deprecated
    public E findByZone(Zone v) {
        return forZoneEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByZone(Zone v) {
        return forZoneEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryIn(Collection<CroppingPlanEntry> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryEquals(CroppingPlanEntry v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanEntry(CroppingPlanEntry v) {
        return forCroppingPlanEntryEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanEntry(CroppingPlanEntry v) {
        return forCroppingPlanEntryEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhaseIn(Collection<EffectiveCropCyclePhase> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectivePerennialCropCycle.PROPERTY_PHASE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhaseEquals(EffectiveCropCyclePhase v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectivePerennialCropCycle.PROPERTY_PHASE, v);
        return result;
    }

    @Deprecated
    public E findByPhase(EffectiveCropCyclePhase v) {
        return forPhaseEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPhase(EffectiveCropCyclePhase v) {
        return forPhaseEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpeciesContains(EffectiveCropCycleSpecies v) {
        return forContains(EffectivePerennialCropCycle.PROPERTY_SPECIES, v);
    }

    @Deprecated
    public E findContainsSpecies(EffectiveCropCycleSpecies v) {
        return forSpeciesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsSpecies(EffectiveCropCycleSpecies v) {
        return forSpeciesContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(entity.getPhase());
        if (entity.getSpecies() != null) {
              tmp.addAll(entity.getSpecies());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedEffectivePerennialCropCycleTopiaDao<E extends EffectivePerennialCropCycle>
