package fr.inra.agrosyst.api.entities.effective;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.MaterielTransportUnit;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.measure.Measurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedEffectiveInterventionTopiaDao<E extends EffectiveIntervention> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) EffectiveIntervention.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.EffectiveIntervention;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            AbstractActionTopiaDao dao = topiaDaoSupplier
                    .getDao(AbstractAction.class, AbstractActionTopiaDao.class);
            List<AbstractAction> list = dao
                    .forProperties(AbstractAction.PROPERTY_EFFECTIVE_INTERVENTION, entity)
                    .findAll();
            for (AbstractAction item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getEffectiveIntervention())) {
                    item.setEffectiveIntervention(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String name, Date startInterventionDate, Date endInterventionDate, AgrosystInterventionType type) {
        return create(EffectiveIntervention.PROPERTY_NAME, name, EffectiveIntervention.PROPERTY_START_INTERVENTION_DATE, startInterventionDate, EffectiveIntervention.PROPERTY_END_INTERVENTION_DATE, endInterventionDate, EffectiveIntervention.PROPERTY_TYPE, type);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStartInterventionDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_START_INTERVENTION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStartInterventionDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_START_INTERVENTION_DATE, v);
        return result;
    }

    @Deprecated
    public E findByStartInterventionDate(Date v) {
        return forStartInterventionDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStartInterventionDate(Date v) {
        return forStartInterventionDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntermediateCropIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_INTERMEDIATE_CROP, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIntermediateCropEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_INTERMEDIATE_CROP, v);
        return result;
    }

    @Deprecated
    public E findByIntermediateCrop(boolean v) {
        return forIntermediateCropEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByIntermediateCrop(boolean v) {
        return forIntermediateCropEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTillageDepthIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_TILLAGE_DEPTH, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTillageDepthEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_TILLAGE_DEPTH, v);
        return result;
    }

    @Deprecated
    public E findByTillageDepth(Integer v) {
        return forTillageDepthEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTillageDepth(Integer v) {
        return forTillageDepthEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherToolSettingsIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_OTHER_TOOL_SETTINGS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherToolSettingsEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_OTHER_TOOL_SETTINGS, v);
        return result;
    }

    @Deprecated
    public E findByOtherToolSettings(String v) {
        return forOtherToolSettingsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtherToolSettings(String v) {
        return forOtherToolSettingsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_WORK_RATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_WORK_RATE, v);
        return result;
    }

    @Deprecated
    public E findByWorkRate(Double v) {
        return forWorkRateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWorkRate(Double v) {
        return forWorkRateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProgressionSpeedIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_PROGRESSION_SPEED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProgressionSpeedEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_PROGRESSION_SPEED, v);
        return result;
    }

    @Deprecated
    public E findByProgressionSpeed(Integer v) {
        return forProgressionSpeedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProgressionSpeed(Integer v) {
        return forProgressionSpeedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInvolvedPeopleCountIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_INVOLVED_PEOPLE_COUNT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInvolvedPeopleCountEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_INVOLVED_PEOPLE_COUNT, v);
        return result;
    }

    @Deprecated
    public E findByInvolvedPeopleCount(Double v) {
        return forInvolvedPeopleCountEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByInvolvedPeopleCount(Double v) {
        return forInvolvedPeopleCountEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndInterventionDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_END_INTERVENTION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndInterventionDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_END_INTERVENTION_DATE, v);
        return result;
    }

    @Deprecated
    public E findByEndInterventionDate(Date v) {
        return forEndInterventionDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEndInterventionDate(Date v) {
        return forEndInterventionDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpatialFrequencyIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_SPATIAL_FREQUENCY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpatialFrequencyEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_SPATIAL_FREQUENCY, v);
        return result;
    }

    @Deprecated
    public E findBySpatialFrequency(double v) {
        return forSpatialFrequencyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySpatialFrequency(double v) {
        return forSpatialFrequencyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitCountIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_TRANSIT_COUNT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitCountEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_TRANSIT_COUNT, v);
        return result;
    }

    @Deprecated
    public E findByTransitCount(int v) {
        return forTransitCountEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTransitCount(int v) {
        return forTransitCountEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_TRANSIT_VOLUME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_TRANSIT_VOLUME, v);
        return result;
    }

    @Deprecated
    public E findByTransitVolume(Double v) {
        return forTransitVolumeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTransitVolume(Double v) {
        return forTransitVolumeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNbBallsIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_NB_BALLS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNbBallsEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_NB_BALLS, v);
        return result;
    }

    @Deprecated
    public E findByNbBalls(Integer v) {
        return forNbBallsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByNbBalls(Integer v) {
        return forNbBallsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdaplosIssuerIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_EDAPLOS_ISSUER_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdaplosIssuerIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_EDAPLOS_ISSUER_ID, v);
        return result;
    }

    @Deprecated
    public E findByEdaplosIssuerId(String v) {
        return forEdaplosIssuerIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEdaplosIssuerId(String v) {
        return forEdaplosIssuerIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEffectiveCropCycleNodeIn(Collection<EffectiveCropCycleNode> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_NODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEffectiveCropCycleNodeEquals(EffectiveCropCycleNode v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_NODE, v);
        return result;
    }

    @Deprecated
    public E findByEffectiveCropCycleNode(EffectiveCropCycleNode v) {
        return forEffectiveCropCycleNodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEffectiveCropCycleNode(EffectiveCropCycleNode v) {
        return forEffectiveCropCycleNodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEffectiveCropCyclePhaseIn(Collection<EffectiveCropCyclePhase> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_PHASE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEffectiveCropCyclePhaseEquals(EffectiveCropCyclePhase v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_PHASE, v);
        return result;
    }

    @Deprecated
    public E findByEffectiveCropCyclePhase(EffectiveCropCyclePhase v) {
        return forEffectiveCropCyclePhaseEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEffectiveCropCyclePhase(EffectiveCropCyclePhase v) {
        return forEffectiveCropCyclePhaseEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forToolCouplingsContains(ToolsCoupling v) {
        return forContains(EffectiveIntervention.PROPERTY_TOOL_COUPLINGS, v);
    }

    @Deprecated
    public E findContainsToolCouplings(ToolsCoupling v) {
        return forToolCouplingsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsToolCouplings(ToolsCoupling v) {
        return forToolCouplingsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpeciesStadesContains(EffectiveSpeciesStade v) {
        return forContains(EffectiveIntervention.PROPERTY_SPECIES_STADES, v);
    }

    @Deprecated
    public E findContainsSpeciesStades(EffectiveSpeciesStade v) {
        return forSpeciesStadesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsSpeciesStades(EffectiveSpeciesStade v) {
        return forSpeciesStadesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<AgrosystInterventionType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(AgrosystInterventionType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(AgrosystInterventionType v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(AgrosystInterventionType v) {
        return forTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMeasurementsContains(Measurement v) {
        return forContains(EffectiveIntervention.PROPERTY_MEASUREMENTS, v);
    }

    @Deprecated
    public E findContainsMeasurements(Measurement v) {
        return forMeasurementsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsMeasurements(Measurement v) {
        return forMeasurementsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInvlovedRulesContains(EffectiveInvolvedRule v) {
        return forContains(EffectiveIntervention.PROPERTY_INVLOVED_RULES, v);
    }

    @Deprecated
    public E findContainsInvlovedRules(EffectiveInvolvedRule v) {
        return forInvlovedRulesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsInvlovedRules(EffectiveInvolvedRule v) {
        return forInvlovedRulesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateUnitIn(Collection<MaterielWorkRateUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_WORK_RATE_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateUnitEquals(MaterielWorkRateUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_WORK_RATE_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByWorkRateUnit(MaterielWorkRateUnit v) {
        return forWorkRateUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWorkRateUnit(MaterielWorkRateUnit v) {
        return forWorkRateUnitEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeUnitIn(Collection<MaterielTransportUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveIntervention.PROPERTY_TRANSIT_VOLUME_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeUnitEquals(MaterielTransportUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveIntervention.PROPERTY_TRANSIT_VOLUME_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByTransitVolumeUnit(MaterielTransportUnit v) {
        return forTransitVolumeUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTransitVolumeUnit(MaterielTransportUnit v) {
        return forTransitVolumeUnitEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == AbstractAction.class) {
            AbstractActionTopiaDao dao =
                topiaDaoSupplier.getDao(AbstractAction.class, AbstractActionTopiaDao.class);
            tmp = dao.forEffectiveInterventionEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(AbstractAction.class, entity);
        if (!list.isEmpty()) {
            result.put(AbstractAction.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getSpeciesStades() != null) {
              tmp.addAll(entity.getSpeciesStades());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedEffectiveInterventionTopiaDao<E extends EffectiveIntervention>
