package fr.inra.agrosyst.api.entities.effective;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedEffectiveCropCyclePhaseTopiaDao<E extends EffectiveCropCyclePhase> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) EffectiveCropCyclePhase.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.EffectiveCropCyclePhase;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            EffectiveInterventionTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveIntervention.class, EffectiveInterventionTopiaDao.class);
            List<EffectiveIntervention> list = dao
                    .forProperties(EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_PHASE, entity)
                    .findAll();
            for (EffectiveIntervention item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getEffectiveCropCyclePhase())) {
                    item.setEffectiveCropCyclePhase(null);
                }
            
            }
        }

        {
            EffectivePerennialCropCycleTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectivePerennialCropCycle.class, EffectivePerennialCropCycleTopiaDao.class);
            List<EffectivePerennialCropCycle> list = dao
                    .forProperties(EffectivePerennialCropCycle.PROPERTY_PHASE, entity)
                    .findAll();
            for (EffectivePerennialCropCycle item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPhase())) {
                    item.setPhase(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(CropCyclePhaseType type) {
        return create(EffectiveCropCyclePhase.PROPERTY_TYPE, type);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDurationIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveCropCyclePhase.PROPERTY_DURATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDurationEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveCropCyclePhase.PROPERTY_DURATION, v);
        return result;
    }

    @Deprecated
    public E findByDuration(Integer v) {
        return forDurationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDuration(Integer v) {
        return forDurationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<CropCyclePhaseType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveCropCyclePhase.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(CropCyclePhaseType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveCropCyclePhase.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(CropCyclePhaseType v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(CropCyclePhaseType v) {
        return forTypeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == EffectiveIntervention.class) {
            EffectiveInterventionTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveIntervention.class, EffectiveInterventionTopiaDao.class);
            tmp = dao.forEffectiveCropCyclePhaseEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectivePerennialCropCycle.class) {
            EffectivePerennialCropCycleTopiaDao dao =
                topiaDaoSupplier.getDao(EffectivePerennialCropCycle.class, EffectivePerennialCropCycleTopiaDao.class);
            tmp = dao.forPhaseEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(EffectiveIntervention.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveIntervention.class, list);
        }

        list = findUsages(EffectivePerennialCropCycle.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectivePerennialCropCycle.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedEffectiveCropCyclePhaseTopiaDao<E extends EffectiveCropCyclePhase>
