package fr.inra.agrosyst.api.entities.effective;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedEffectiveCropCycleNodeTopiaDao<E extends EffectiveCropCycleNode> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) EffectiveCropCycleNode.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.EffectiveCropCycleNode;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            EffectiveInterventionTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveIntervention.class, EffectiveInterventionTopiaDao.class);
            List<EffectiveIntervention> list = dao
                    .forProperties(EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_NODE, entity)
                    .findAll();
            for (EffectiveIntervention item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getEffectiveCropCycleNode())) {
                    item.setEffectiveCropCycleNode(null);
                }
            
            }
        }

        {
            EffectiveCropCycleConnectionTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveCropCycleConnection.class, EffectiveCropCycleConnectionTopiaDao.class);
            List<EffectiveCropCycleConnection> list = dao
                    .forProperties(EffectiveCropCycleConnection.PROPERTY_TARGET, entity)
                    .findAll();
            for (EffectiveCropCycleConnection item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getTarget())) {
                    item.setTarget(null);
                }
            
            }
        }

        {
            EffectiveCropCycleConnectionTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveCropCycleConnection.class, EffectiveCropCycleConnectionTopiaDao.class);
            List<EffectiveCropCycleConnection> list = dao
                    .forProperties(EffectiveCropCycleConnection.PROPERTY_SOURCE, entity)
                    .findAll();
            for (EffectiveCropCycleConnection item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSource())) {
                    item.setSource(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(CroppingPlanEntry croppingPlanEntry) {
        return create(EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY, croppingPlanEntry);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRankIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveCropCycleNode.PROPERTY_RANK, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRankEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveCropCycleNode.PROPERTY_RANK, v);
        return result;
    }

    @Deprecated
    public E findByRank(int v) {
        return forRankEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRank(int v) {
        return forRankEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdaplosIssuerIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveCropCycleNode.PROPERTY_EDAPLOS_ISSUER_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEdaplosIssuerIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveCropCycleNode.PROPERTY_EDAPLOS_ISSUER_ID, v);
        return result;
    }

    @Deprecated
    public E findByEdaplosIssuerId(String v) {
        return forEdaplosIssuerIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEdaplosIssuerId(String v) {
        return forEdaplosIssuerIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryIn(Collection<CroppingPlanEntry> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryEquals(CroppingPlanEntry v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanEntry(CroppingPlanEntry v) {
        return forCroppingPlanEntryEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanEntry(CroppingPlanEntry v) {
        return forCroppingPlanEntryEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == EffectiveSeasonalCropCycle.class) {
            EffectiveSeasonalCropCycleTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveSeasonalCropCycle.class, EffectiveSeasonalCropCycleTopiaDao.class);
            tmp = dao.forNodesContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveIntervention.class) {
            EffectiveInterventionTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveIntervention.class, EffectiveInterventionTopiaDao.class);
            tmp = dao.forEffectiveCropCycleNodeEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveCropCycleConnection.class) {
            EffectiveCropCycleConnectionTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveCropCycleConnection.class, EffectiveCropCycleConnectionTopiaDao.class);
            tmp = dao.forTargetEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveCropCycleConnection.class) {
            EffectiveCropCycleConnectionTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveCropCycleConnection.class, EffectiveCropCycleConnectionTopiaDao.class);
            tmp = dao.forSourceEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(EffectiveSeasonalCropCycle.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveSeasonalCropCycle.class, list);
        }

        list = findUsages(EffectiveIntervention.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveIntervention.class, list);
        }

        list = findUsages(EffectiveCropCycleConnection.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveCropCycleConnection.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedEffectiveCropCycleNodeTopiaDao<E extends EffectiveCropCycleNode>
