package fr.inra.agrosyst.api.entities.effective;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: EffectivePerennialCropCycleTopiaDao.java 3691 2014-03-10 17:02:53Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/effective/EffectivePerennialCropCycleTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.utils.DaoUtils;

public class EffectivePerennialCropCycleTopiaDao extends AbstractEffectivePerennialCropCycleTopiaDao<EffectivePerennialCropCycle> {

    /**
     * Recherche le cycle qui contient l'intervention.
     * 
     * @param effectiveIntervention intervention
     * @return
     */
    public EffectivePerennialCropCycle findPerennialCropCycleForIntervention(EffectiveIntervention effectiveIntervention) {
        String query = "FROM " + EffectivePerennialCropCycle.class.getName() + " C" +
                " WHERE :effectiveCropCyclePhase = C." + EffectivePerennialCropCycle.PROPERTY_PHASE;

        return findUnique(query, DaoUtils.asArgsMap("effectiveCropCyclePhase", effectiveIntervention.getEffectiveCropCyclePhase()));
    }

} //EffectivePerennialCropCycleTopiaDao
