package fr.inra.agrosyst.api.entities.effective;

import java.util.Map;

import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.utils.DaoUtils;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: EffectiveInterventionTopiaDao.java 4133 2014-07-04 13:52:42Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/effective/EffectiveInterventionTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

public class EffectiveInterventionTopiaDao extends AbstractEffectiveInterventionTopiaDao<EffectiveIntervention> {

    public EffectiveIntervention findFirstInterventionWithSeedingAction(EffectiveCropCyclePhase effectiveCropCyclePhase) {
        String query = "FROM " + EffectiveIntervention.class.getName() + " I" +
                " WHERE I." + EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_PHASE + " = :phase" +
                " AND EXISTS (FROM " + SeedingAction.class.getName() + " A" +
                "    WHERE A." + SeedingAction.PROPERTY_EFFECTIVE_INTERVENTION + " = I)";

        Map<String, Object> args = DaoUtils.asArgsMap("phase", effectiveCropCyclePhase);

        // S'il y a deux actions qui ont des actions de semis, ont prend celle dont la date est la plus ancienne (cf. http://forge.codelutin.com/issues/5325)
        EffectiveIntervention result = findFirstOrNull(query + " ORDER BY I." + EffectiveIntervention.PROPERTY_START_INTERVENTION_DATE + " ASC ", args);
        return result;
    }

    public EffectiveIntervention findFirstInterventionWithSeedingAction(EffectiveCropCycleNode effectiveCropCycleNode) {
        String query = "FROM " + EffectiveIntervention.class.getName() + " I" +
                " WHERE I." + EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_NODE + " = :node" +
                " AND EXISTS (FROM " + SeedingAction.class.getName() + " A" +
                "    WHERE A." + SeedingAction.PROPERTY_EFFECTIVE_INTERVENTION + " = I)";

        Map<String, Object> args = DaoUtils.asArgsMap("node", effectiveCropCycleNode);

        // S'il y a deux actions qui ont des actions de semis, ont prend celle dont la date est la plus ancienne (cf. http://forge.codelutin.com/issues/5325)
        EffectiveIntervention result = findFirstOrNull(query + " ORDER BY I." + EffectiveIntervention.PROPERTY_START_INTERVENTION_DATE + " ASC ", args);
        return result;
    }

} //EffectiveInterventionTopiaDao
