package fr.inra.agrosyst.api.entities.effective;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: EffectiveCropCycleNodeTopiaDao.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/effective/EffectiveCropCycleNodeTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.Zone;

public class EffectiveCropCycleNodeTopiaDao extends AbstractEffectiveCropCycleNodeTopiaDao<EffectiveCropCycleNode> {

    /**
     * Recherche pour une zone, le dernier noeud défini par la campagne précédente.
     * 
     * @param zone zone
     * @return last year node (or {@code null})
     */
    public EffectiveCropCycleNode findLastNodeForPreviousCampaign(Zone zone) {
        String query = "FROM " + getEntityClass().getName() + " N" +
                " WHERE exists (" +
                "  FROM " + EffectiveSeasonalCropCycle.class.getName() + " CC" +
                "   WHERE N in elements(CC.nodes) AND CC.zone.code = :code AND CC.zone.plot.domain.campaign = :campaign" +
                ") ORDER by N.rank DESC";

        Map<String, Object> args = Maps.newHashMap();
        args.put("code", zone.getCode());
        args.put("campaign", zone.getPlot().getDomain().getCampaign() - 1);
        EffectiveCropCycleNode result = findFirstOrNull(query, args);
        return result;
    }

} //EffectiveCropCycleNodeTopiaDao
