package fr.inra.agrosyst.api.entities.effective;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: EffectiveCropCycleConnectionTopiaDao.java 4267 2014-08-13 13:40:30Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/effective/EffectiveCropCycleConnectionTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collections;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class EffectiveCropCycleConnectionTopiaDao extends AbstractEffectiveCropCycleConnectionTopiaDao<EffectiveCropCycleConnection> {

    /**
     * Retourne les connexions qui appartiennent au cycle.
     * Via une requete, car la navigabilité ne permet pas la navigation.
     * 
     * @param cycle le cycle qui contient les connexions
     * @return all cycle's connections
     */
    public List<EffectiveCropCycleConnection> findAllByEffectiveSeasonalCropCycle(EffectiveSeasonalCropCycle cycle) {
        List<EffectiveCropCycleConnection> result;
        // prevent query bug if nodes collection is empty
        if (CollectionUtils.isEmpty(cycle.getNodes())) {
            result = Collections.emptyList();
        } else {
            String query = "FROM " + getEntityClass().getName() + " C" +
                " WHERE (C." + EffectiveCropCycleConnection.PROPERTY_SOURCE + " IN (:cycleNodes) OR C." + EffectiveCropCycleConnection.PROPERTY_SOURCE + " IS NULL)" +
                " AND C." + EffectiveCropCycleConnection.PROPERTY_TARGET + " IN (:cycleNodes)";

            result = findAll(query, DaoUtils.asArgsMap("cycleNodes", cycle.getNodes()));

        }
        return result;
    }
}
