package fr.inra.agrosyst.api.entities.action;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PhytoProductInputTopiaDao.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/action/PhytoProductInputTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.utils.DaoUtils;

public class PhytoProductInputTopiaDao extends AbstractPhytoProductInputTopiaDao<PhytoProductInput> {

    /**
     * Search all phyto product input defined on actions in given effective intervention.
     * 
     * @param effectiveIntervention effective intervention
     * @return phyto product used by intervention
     */
    public List<PhytoProductInput> findAllByEffectiveIntervention(EffectiveIntervention effectiveIntervention) {
        return findAllByIntervention(AbstractAction.PROPERTY_EFFECTIVE_INTERVENTION, effectiveIntervention);
    }
    
    /**
     * Search all phyto product input defined on actions in given practiced intervention.
     * 
     * @param practicedIntervention practiced intervention
     * @return phyto product used by intervention
     */
    public List<PhytoProductInput> findAllByPracticedIntervention(PracticedIntervention practicedIntervention) {
        return findAllByIntervention(AbstractAction.PROPERTY_PRACTICED_INTERVENTION, practicedIntervention);
    }
    
    protected List<PhytoProductInput> findAllByIntervention(String property, Object intervention) {
        StringBuilder query = new StringBuilder("FROM " + getEntityClass().getName() + " PI WHERE ");
        query.append(" PI IN (SELECT SPI FROM " + SeedingProductInput.class.getName() + " SPI WHERE SPI.");
        query.append(SeedingProductInput.PROPERTY_SEEDING_ACTION + "." + property + " = :" + property);
        query.append(" ) OR PI IN (SELECT BPI FROM " + BiologicalProductInput.class.getName() + " BPI WHERE BPI.");
        query.append(BiologicalProductInput.PROPERTY_BIOLOGICAL_CONTROL_ACTION + "." + property + " = :" + property);
        query.append(" ) OR PI IN (SELECT PPI FROM " + PesticideProductInput.class.getName() + " PPI WHERE PPI.");
        query.append(PesticideProductInput.PROPERTY_PESTICIDES_SPREADING_ACTION + "." + property + " = :" + property);
        query.append(")");

        Map<String, Object> args = DaoUtils.asArgsMap(property, intervention);
        List<PhytoProductInput> products = findAll(query.toString(), args);
        return products;
    }
}
