package fr.inra.agrosyst.api.entities.action;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedSeedingActionTopiaDao<E extends SeedingAction> extends AbstractAbstractActionTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) SeedingAction.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.SeedingAction;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            SeedingProductInputTopiaDao dao = topiaDaoSupplier
                    .getDao(SeedingProductInput.class, SeedingProductInputTopiaDao.class);
            List<SeedingProductInput> list = dao
                    .forProperties(SeedingProductInput.PROPERTY_SEEDING_ACTION, entity)
                    .findAll();
            for (SeedingProductInput item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSeedingAction())) {
                    item.setSeedingAction(null);
                }
            
            }
        }

        {
            OtherProductInputTopiaDao dao = topiaDaoSupplier
                    .getDao(OtherProductInput.class, OtherProductInputTopiaDao.class);
            List<OtherProductInput> list = dao
                    .forProperties(OtherProductInput.PROPERTY_SEEDING_ACTION, entity)
                    .findAll();
            for (OtherProductInput item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getSeedingAction())) {
                    item.setSeedingAction(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(RefInterventionAgrosystTravailEDI mainAction) {
        return create(SeedingAction.PROPERTY_MAIN_ACTION, mainAction);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forYealdTargetIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SeedingAction.PROPERTY_YEALD_TARGET, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forYealdTargetEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SeedingAction.PROPERTY_YEALD_TARGET, v);
        return result;
    }

    @Deprecated
    public E findByYealdTarget(Double v) {
        return forYealdTargetEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByYealdTarget(Double v) {
        return forYealdTargetEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSeedTypeIn(Collection<SeedType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SeedingAction.PROPERTY_SEED_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSeedTypeEquals(SeedType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SeedingAction.PROPERTY_SEED_TYPE, v);
        return result;
    }

    @Deprecated
    public E findBySeedType(SeedType v) {
        return forSeedTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySeedType(SeedType v) {
        return forSeedTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSeedingSpeciesContains(SeedingActionSpecies v) {
        return forContains(SeedingAction.PROPERTY_SEEDING_SPECIES, v);
    }

    @Deprecated
    public E findContainsSeedingSpecies(SeedingActionSpecies v) {
        return forSeedingSpeciesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsSeedingSpecies(SeedingActionSpecies v) {
        return forSeedingSpeciesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forYealdUnitIn(Collection<YealdUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(SeedingAction.PROPERTY_YEALD_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forYealdUnitEquals(YealdUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(SeedingAction.PROPERTY_YEALD_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByYealdUnit(YealdUnit v) {
        return forYealdUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByYealdUnit(YealdUnit v) {
        return forYealdUnitEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == SeedingProductInput.class) {
            SeedingProductInputTopiaDao dao =
                topiaDaoSupplier.getDao(SeedingProductInput.class, SeedingProductInputTopiaDao.class);
            tmp = dao.forSeedingActionEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == OtherProductInput.class) {
            OtherProductInputTopiaDao dao =
                topiaDaoSupplier.getDao(OtherProductInput.class, OtherProductInputTopiaDao.class);
            tmp = dao.forSeedingActionEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(SeedingProductInput.class, entity);
        if (!list.isEmpty()) {
            result.put(SeedingProductInput.class, list);
        }

        list = findUsages(OtherProductInput.class, entity);
        if (!list.isEmpty()) {
            result.put(OtherProductInput.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getSeedingSpecies() != null) {
              tmp.addAll(entity.getSeedingSpecies());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedSeedingActionTopiaDao<E extends SeedingAction>
