package fr.inra.agrosyst.api.entities.action;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedPhytoProductInputTopiaDao<E extends PhytoProductInput> extends AbstractAbstractInputTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) PhytoProductInput.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.PhytoProductInput;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(AgrosystInterventionType inputType) {
        return create(PhytoProductInput.PROPERTY_INPUT_TYPE, inputType);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProductTypeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PhytoProductInput.PROPERTY_PRODUCT_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProductTypeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PhytoProductInput.PROPERTY_PRODUCT_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByProductType(String v) {
        return forProductTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProductType(String v) {
        return forProductTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhytoProductIn(Collection<RefActaTraitementsProduit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PhytoProductInput.PROPERTY_PHYTO_PRODUCT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhytoProductEquals(RefActaTraitementsProduit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PhytoProductInput.PROPERTY_PHYTO_PRODUCT, v);
        return result;
    }

    @Deprecated
    public E findByPhytoProduct(RefActaTraitementsProduit v) {
        return forPhytoProductEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPhytoProduct(RefActaTraitementsProduit v) {
        return forPhytoProductEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTargetsContains(RefBioAgressor v) {
        return forContains(PhytoProductInput.PROPERTY_TARGETS, v);
    }

    @Deprecated
    public E findContainsTargets(RefBioAgressor v) {
        return forTargetsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsTargets(RefBioAgressor v) {
        return forTargetsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhytoProductUnitIn(Collection<PhytoProductUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PhytoProductInput.PROPERTY_PHYTO_PRODUCT_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhytoProductUnitEquals(PhytoProductUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PhytoProductInput.PROPERTY_PHYTO_PRODUCT_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByPhytoProductUnit(PhytoProductUnit v) {
        return forPhytoProductUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPhytoProductUnit(PhytoProductUnit v) {
        return forPhytoProductUnitEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPhytoProductInputTopiaDao<E extends PhytoProductInput>
