package fr.inra.agrosyst.api.entities.action;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedPesticidesSpreadingActionTopiaDao<E extends PesticidesSpreadingAction> extends AbstractAbstractActionTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) PesticidesSpreadingAction.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.PesticidesSpreadingAction;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PesticideProductInputTopiaDao dao = topiaDaoSupplier
                    .getDao(PesticideProductInput.class, PesticideProductInputTopiaDao.class);
            List<PesticideProductInput> list = dao
                    .forProperties(PesticideProductInput.PROPERTY_PESTICIDES_SPREADING_ACTION, entity)
                    .findAll();
            for (PesticideProductInput item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPesticidesSpreadingAction())) {
                    item.setPesticidesSpreadingAction(null);
                }
            
            }
        }

        {
            OtherProductInputTopiaDao dao = topiaDaoSupplier
                    .getDao(OtherProductInput.class, OtherProductInputTopiaDao.class);
            List<OtherProductInput> list = dao
                    .forProperties(OtherProductInput.PROPERTY_PESTICIDES_SPREADING_ACTION, entity)
                    .findAll();
            for (OtherProductInput item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPesticidesSpreadingAction())) {
                    item.setPesticidesSpreadingAction(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(RefInterventionAgrosystTravailEDI mainAction) {
        return create(PesticidesSpreadingAction.PROPERTY_MAIN_ACTION, mainAction);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBoiledQuantityIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PesticidesSpreadingAction.PROPERTY_BOILED_QUANTITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBoiledQuantityEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PesticidesSpreadingAction.PROPERTY_BOILED_QUANTITY, v);
        return result;
    }

    @Deprecated
    public E findByBoiledQuantity(Double v) {
        return forBoiledQuantityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByBoiledQuantity(Double v) {
        return forBoiledQuantityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBoiledQuantityPerTripIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PesticidesSpreadingAction.PROPERTY_BOILED_QUANTITY_PER_TRIP, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBoiledQuantityPerTripEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PesticidesSpreadingAction.PROPERTY_BOILED_QUANTITY_PER_TRIP, v);
        return result;
    }

    @Deprecated
    public E findByBoiledQuantityPerTrip(Double v) {
        return forBoiledQuantityPerTripEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByBoiledQuantityPerTrip(Double v) {
        return forBoiledQuantityPerTripEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTripFrequencyIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PesticidesSpreadingAction.PROPERTY_TRIP_FREQUENCY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTripFrequencyEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PesticidesSpreadingAction.PROPERTY_TRIP_FREQUENCY, v);
        return result;
    }

    @Deprecated
    public E findByTripFrequency(Double v) {
        return forTripFrequencyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTripFrequency(Double v) {
        return forTripFrequencyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAntiDriftNozzleIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PesticidesSpreadingAction.PROPERTY_ANTI_DRIFT_NOZZLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAntiDriftNozzleEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PesticidesSpreadingAction.PROPERTY_ANTI_DRIFT_NOZZLE, v);
        return result;
    }

    @Deprecated
    public E findByAntiDriftNozzle(boolean v) {
        return forAntiDriftNozzleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAntiDriftNozzle(boolean v) {
        return forAntiDriftNozzleEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProportionOfTreatedSurfaceIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(PesticidesSpreadingAction.PROPERTY_PROPORTION_OF_TREATED_SURFACE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProportionOfTreatedSurfaceEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(PesticidesSpreadingAction.PROPERTY_PROPORTION_OF_TREATED_SURFACE, v);
        return result;
    }

    @Deprecated
    public E findByProportionOfTreatedSurface(double v) {
        return forProportionOfTreatedSurfaceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProportionOfTreatedSurface(double v) {
        return forProportionOfTreatedSurfaceEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == PesticideProductInput.class) {
            PesticideProductInputTopiaDao dao =
                topiaDaoSupplier.getDao(PesticideProductInput.class, PesticideProductInputTopiaDao.class);
            tmp = dao.forPesticidesSpreadingActionEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == OtherProductInput.class) {
            OtherProductInputTopiaDao dao =
                topiaDaoSupplier.getDao(OtherProductInput.class, OtherProductInputTopiaDao.class);
            tmp = dao.forPesticidesSpreadingActionEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(PesticideProductInput.class, entity);
        if (!list.isEmpty()) {
            result.put(PesticideProductInput.class, list);
        }

        list = findUsages(OtherProductInput.class, entity);
        if (!list.isEmpty()) {
            result.put(OtherProductInput.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPesticidesSpreadingActionTopiaDao<E extends PesticidesSpreadingAction>
