package fr.inra.agrosyst.api.entities.action;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedOrganicProductInputTopiaDao<E extends OrganicProductInput> extends AbstractAbstractInputTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) OrganicProductInput.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.OrganicProductInput;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(AgrosystInterventionType inputType) {
        return create(OrganicProductInput.PROPERTY_INPUT_TYPE, inputType);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(OrganicProductInput.PROPERTY_N, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(OrganicProductInput.PROPERTY_N, v);
        return result;
    }

    @Deprecated
    public E findByN(double v) {
        return forNEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByN(double v) {
        return forNEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forP2O5In(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(OrganicProductInput.PROPERTY_P2_O5, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forP2O5Equals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(OrganicProductInput.PROPERTY_P2_O5, v);
        return result;
    }

    @Deprecated
    public E findByP2O5(double v) {
        return forP2O5Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByP2O5(double v) {
        return forP2O5Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forK2OIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(OrganicProductInput.PROPERTY_K2_O, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forK2OEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(OrganicProductInput.PROPERTY_K2_O, v);
        return result;
    }

    @Deprecated
    public E findByK2O(double v) {
        return forK2OEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByK2O(double v) {
        return forK2OEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganicProductIn(Collection<RefFertiOrga> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(OrganicProductInput.PROPERTY_ORGANIC_PRODUCT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganicProductEquals(RefFertiOrga v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(OrganicProductInput.PROPERTY_ORGANIC_PRODUCT, v);
        return result;
    }

    @Deprecated
    public E findByOrganicProduct(RefFertiOrga v) {
        return forOrganicProductEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrganicProduct(RefFertiOrga v) {
        return forOrganicProductEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganicFertilizersSpreadingActionIn(Collection<OrganicFertilizersSpreadingAction> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(OrganicProductInput.PROPERTY_ORGANIC_FERTILIZERS_SPREADING_ACTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganicFertilizersSpreadingActionEquals(OrganicFertilizersSpreadingAction v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(OrganicProductInput.PROPERTY_ORGANIC_FERTILIZERS_SPREADING_ACTION, v);
        return result;
    }

    @Deprecated
    public E findByOrganicFertilizersSpreadingAction(OrganicFertilizersSpreadingAction v) {
        return forOrganicFertilizersSpreadingActionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrganicFertilizersSpreadingAction(OrganicFertilizersSpreadingAction v) {
        return forOrganicFertilizersSpreadingActionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganicProductUnitIn(Collection<OrganicProductUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(OrganicProductInput.PROPERTY_ORGANIC_PRODUCT_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganicProductUnitEquals(OrganicProductUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(OrganicProductInput.PROPERTY_ORGANIC_PRODUCT_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByOrganicProductUnit(OrganicProductUnit v) {
        return forOrganicProductUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrganicProductUnit(OrganicProductUnit v) {
        return forOrganicProductUnitEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedOrganicProductInputTopiaDao<E extends OrganicProductInput>
